/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.index.model.Field;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class NumericIntegerConditionInspectorConflictResolverOverlapTest {
    @Mock
    private Field field;

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true}, {"!=", 0, "!=", 0, true}, {">", 0, ">", 0, true}, {">=", 0, ">=", 0, true}, {"<", 0, "<", 0, true}, {"<=", 0, "<=", 0, true}, {"==", 0, "==", 1, false}, {"==", 0, "!=", 0, false}, {"==", 0, ">", 0, false}, {"==", 0, ">", 10, false}, {"==", 0, ">=", 1, false}, {"==", 0, ">=", 10, false}, {"==", 0, "<", 0, false}, {"==", 0, "<", -10, false}, {"==", 0, "<=", -1, false}, {"==", 0, "<=", -10, false}, {"==", 0, "!=", 1, true}, {"==", 0, ">", -1, true}, {"==", 0, ">", -10, true}, {"==", 0, ">=", 0, true}, {"==", 0, ">=", -10, true}, {"==", 0, "<", 1, true}, {"==", 0, "<", 10, true}, {"==", 0, "<=", 0, true}, {"==", 0, "<=", 10, true}, {"!=", 0, "!=", 1, true}, {"!=", 0, ">", -1, true}, {"!=", 0, ">", -10, true}, {"!=", 0, ">=", 0, true}, {"!=", 0, ">=", -10, true}, {"!=", 0, "<", 1, true}, {"!=", 0, "<", 10, true}, {"!=", 0, "<=", 0, true}, {"!=", 0, "<=", 10, true}, {">", 0, "<", 1, true}, {">", 0, "<", -10, false}, {">", 0, "<=", 0, false}, {">", 0, "<=", -10, false}, {">", 0, ">", -1, true}, {">", 0, ">", -10, true}, {">", 0, ">=", 0, true}, {">", 0, ">=", 1, true}, {">", 0, ">=", -10, true}, {">", 0, "<", 2, true}, {">", 0, "<", 10, true}, {">", 0, "<=", 1, true}, {">", 0, "<=", 10, true}, {">=", 0, "<", 0, false}, {">=", 0, "<", -10, false}, {">=", 0, "<=", -1, false}, {">=", 0, "<=", -10, false}, {">=", 0, ">=", 1, true}, {">=", 0, ">=", -10, true}, {">=", 0, "<", 1, true}, {">=", 0, "<", 10, true}, {">=", 0, "<=", 0, true}, {">=", 0, "<=", 10, true}, {"<", 0, "<", 1, true}, {"<", 0, "<", 10, true}, {"<", 0, "<=", -1, true}, {"<", 0, "<=", 0, true}, {"<", 0, "<=", 10, true}, {"<=", 0, "<=", -1, true}, {"<=", 0, "<=", 10, true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedOverlapTest(String operator1, Integer value1, String operator2, Integer value2, boolean overlapExpected) {
        NumericIntegerConditionInspector a = ConditionInspectorUtils.getNumericCondition(this.field, value1, operator1);
        NumericIntegerConditionInspector b = ConditionInspectorUtils.getNumericCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.overlaps((Object)b)).as(this.getAssertDescription(a, b, overlapExpected, "overlap"), new Object[0])).isEqualTo(overlapExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.overlaps((Object)a)).as(this.getAssertDescription(b, a, overlapExpected, "overlap"), new Object[0])).isEqualTo(overlapExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedConflictTest(String operator1, Integer value1, String operator2, Integer value2, boolean overlapExpected) {
        NumericIntegerConditionInspector a = ConditionInspectorUtils.getNumericCondition(this.field, value1, operator1);
        NumericIntegerConditionInspector b = ConditionInspectorUtils.getNumericCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.conflicts((Object)b)).as(this.getAssertDescription(a, b, !overlapExpected, "conflict"), new Object[0])).isEqualTo(!overlapExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.conflicts((Object)a)).as(this.getAssertDescription(b, a, !overlapExpected, "conflict"), new Object[0])).isEqualTo(!overlapExpected);
    }

    private String getAssertDescription(NumericIntegerConditionInspector a, NumericIntegerConditionInspector b, boolean conflictExpected, String condition) {
        return String.format("Expected condition '%s' %sto %s with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", condition, b.toHumanReadableString());
    }
}

