/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.index.model.Field;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class NumericIntegerConditionInspectorSubsumptionTest {
    @Mock
    private Field field;

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true, true}, {"!=", 0, "!=", 0, true, true}, {">", 0, ">", 0, true, true}, {">=", 0, ">=", 0, true, true}, {"<", 0, "<", 0, true, true}, {"<=", 0, "<=", 0, true, true}, {"==", 0, "==", 1, false, false}, {"==", 0, "!=", 0, false, false}, {"==", 0, ">", 0, false, false}, {"==", 0, ">", 10, false, false}, {"==", 0, ">=", 1, false, false}, {"==", 0, ">=", 10, false, false}, {"==", 0, "<", 0, false, false}, {"==", 0, "<", -10, false, false}, {"==", 0, "<=", -1, false, false}, {"==", 0, "<=", -10, false, false}, {"==", 0, "!=", 1, true, false}, {"==", 0, ">", -1, false, true}, {"==", 0, ">", -10, false, true}, {"==", 0, ">=", 0, false, true}, {"==", 0, ">=", -10, false, true}, {"==", 0, "<", 1, false, true}, {"==", 0, "<", 10, false, true}, {"==", 0, "<=", 0, false, true}, {"==", 0, "<=", 10, false, true}, {"!=", 0, "!=", 1, false, false}, {"!=", 0, ">", -1, false, false}, {"!=", 0, ">", -10, false, false}, {"!=", 0, ">=", 0, false, false}, {"!=", 0, ">=", -10, false, false}, {"!=", 0, "<", 1, false, false}, {"!=", 0, "<", 10, false, false}, {"!=", 0, "<=", 0, false, false}, {"!=", 0, "<=", 10, false, false}, {"!=", 0, ">", 0, true, false}, {"!=", 0, ">", 10, true, false}, {"!=", 0, ">=", 1, true, false}, {"!=", 0, ">=", 10, true, false}, {"!=", 0, "<", 0, true, false}, {"!=", 0, "<", -10, true, false}, {"!=", 0, "<=", -1, true, false}, {"!=", 0, "<=", -10, true, false}, {">", 0, "<", 1, false, false}, {">", 0, "<", -10, false, false}, {">", 0, "<", 10, false, false}, {">", 0, "<=", 0, false, false}, {">", 0, "<=", -10, false, false}, {">", 0, "<=", 10, false, false}, {">", 0, ">", 1, true, false}, {">", 0, ">", 10, true, false}, {">", 0, ">=", 0, false, true}, {">", 0, ">=", 10, true, false}, {">=", 0, "<", 0, false, false}, {">=", 0, "<", -10, false, false}, {">=", 0, "<", 10, false, false}, {">=", 0, "<=", -1, false, false}, {">=", 0, "<=", -10, false, false}, {">=", 0, "<=", 10, false, false}, {">=", 0, ">=", 1, true, false}, {">=", 0, ">=", 10, true, false}, {"<", 0, "<", 1, false, true}, {"<", 0, "<", 10, false, true}, {"<", 0, "<=", 0, false, true}, {"<", 0, "<=", 10, false, true}, {"<=", 0, "<=", 1, false, true}, {"<=", 0, "<=", 10, false, true}, {">", 0, ">=", 1, true, true}, {"<", 0, "<=", -1, true, true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void testASubsumesB(String operator1, Integer value1, String operator2, Integer value2, boolean aSubsumesB, boolean bSubsumesA) {
        NumericIntegerConditionInspector a = ConditionInspectorUtils.getNumericCondition(this.field, value1, operator1);
        NumericIntegerConditionInspector b = ConditionInspectorUtils.getNumericCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.subsumes((Object)b)).as(ConditionInspectorUtils.getAssertDescriptionForRedundant((ComparableConditionInspector)a, (ComparableConditionInspector)b, aSubsumesB), new Object[0])).isEqualTo(aSubsumesB);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void testBSubsumesA(String operator1, Integer value1, String operator2, Integer value2, boolean aSubsumesB, boolean bSubsumesA) {
        NumericIntegerConditionInspector a = ConditionInspectorUtils.getNumericCondition(this.field, value1, operator1);
        NumericIntegerConditionInspector b = ConditionInspectorUtils.getNumericCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.subsumes((Object)a)).as(ConditionInspectorUtils.getAssertDescriptionForRedundant((ComparableConditionInspector)b, (ComparableConditionInspector)a, bSubsumesA), new Object[0])).isEqualTo(bSubsumesA);
    }
}

