/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.relations.Operator;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StringConditionInspectorCoverTest {
    @Mock
    private Field field;

    public static Collection<Object[]> testData() {
        return Arrays.asList({new Values(new Comparable[]{"toni"}), Operator.EQUALS.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.MATCHES.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.SOUNDSLIKE.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni", "eder"}), Operator.IN.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.GREATER_OR_EQUAL.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.LESS_OR_EQUAL.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.LESS_THAN.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni"}), Operator.GREATER_THAN.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni"}), Operator.EQUALS.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni"}), Operator.MATCHES.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni"}), Operator.SOUNDSLIKE.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni", "eder"}), Operator.IN.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni"}), Operator.GREATER_OR_EQUAL.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni"}), Operator.LESS_OR_EQUAL.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni", "eder"}), Operator.NOT_IN.toString(), new Values(new Comparable[]{"michael"}), true}, {new Values(new Comparable[]{"toni", "eder"}), Operator.NOT_IN.toString(), new Values(new Comparable[]{"eder"}), false}, {new Values(new Comparable[]{"toni"}), Operator.NOT_EQUALS.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni"}), Operator.NOT_EQUALS.toString(), new Values(new Comparable[]{"eder"}), true}, {new Values(new Comparable[]{"toni"}), Operator.NOT_MATCHES.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni"}), Operator.NOT_MATCHES.toString(), new Values(new Comparable[]{"eder"}), true}, {new Values(new Comparable[]{"toni rikkola"}), Operator.STR_ENDS_WITH.toString(), new Values(new Comparable[]{"rikkola"}), true}, {new Values(new Comparable[]{"toni rikkola"}), Operator.STR_ENDS_WITH.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni rikkola"}), Operator.STR_STARTS_WITH.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni rikkola"}), Operator.STR_STARTS_WITH.toString(), new Values(new Comparable[]{"rikkola"}), false}, {new Values(new Comparable[]{"array"}), Operator.CONTAINS.toString(), new Values(new Comparable[]{"toni", "eder"}), false}, {new Values(new Comparable[]{"array"}), Operator.CONTAINS.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"array"}), Operator.CONTAINS.toString(), new Values(new Comparable[]{"eder"}), false}, {new Values(new Comparable[]{"array"}), Operator.NOT_CONTAINS.toString(), new Values(new Comparable[]{"toni", "eder"}), false}, {new Values(new Comparable[]{"array"}), Operator.NOT_CONTAINS.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"array"}), Operator.NOT_CONTAINS.toString(), new Values(new Comparable[]{"eder"}), false});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedTest(Values<String> value1, String operator, Values<String> value2, boolean covers) {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, value1, operator);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.covers((Comparable)value2.iterator().next())).as(this.getAssertDescription(a, covers, (String)value2.iterator().next()), new Object[0])).isEqualTo(covers);
    }

    private String getAssertDescription(StringConditionInspector a, boolean covers, String condition) {
        return String.format("Expected condition '%s' to %s cover '%s':", a.toHumanReadableString(), covers ? "" : "not ", condition);
    }
}

