/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks.base;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.PairCheck;
import org.drools.verifier.core.checks.base.PairCheckBundle;
import org.drools.verifier.core.checks.base.PairCheckStorage;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class PairCheckStorageListTest {
    private PairCheckStorage pairCheckStorage;
    @Mock
    private RuleInspector a;
    @Mock
    private RuleInspector b;
    @Mock
    private RuleInspector c;
    private PairCheckBundle pairCheckListOne;
    private PairCheckBundle pairCheckListTwo;

    @BeforeEach
    public void setUp() throws Exception {
        this.pairCheckStorage = new PairCheckStorage();
        this.pairCheckListOne = new PairCheckBundle(this.a, this.b, this.newMockList());
        this.pairCheckStorage.add(this.pairCheckListOne);
        this.pairCheckListTwo = new PairCheckBundle(this.b, this.a, this.newMockList());
        this.pairCheckStorage.add(this.pairCheckListTwo);
        this.pairCheckStorage.add(new PairCheckBundle(this.a, this.c, this.newMockList()));
        this.pairCheckStorage.add(new PairCheckBundle(this.c, this.a, this.newMockList()));
    }

    private List<Check> newMockList() {
        return List.of((Check)Mockito.mock(PairCheck.class));
    }

    @Test
    void getA() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.get(this.a);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)pairCheckLists).hasSize(4)).contains((Object[])new PairCheckBundle[]{this.pairCheckListOne, this.pairCheckListTwo});
    }

    @Test
    void getB() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.get(this.b);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)pairCheckLists).hasSize(2)).contains((Object[])new PairCheckBundle[]{this.pairCheckListOne, this.pairCheckListTwo});
    }

    @Test
    void removeB() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.remove(this.b);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)pairCheckLists).hasSize(2)).contains((Object[])new PairCheckBundle[]{this.pairCheckListOne, this.pairCheckListTwo});
        Assertions.assertThat((Collection)this.pairCheckStorage.get(this.b)).isEmpty();
        Collection pairChecksForAList = this.pairCheckStorage.get(this.a);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)pairChecksForAList).hasSize(2)).doesNotContain((Object[])new PairCheckBundle[]{this.pairCheckListOne, this.pairCheckListTwo});
    }

    @Test
    void removeA() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.remove(this.a);
        Assertions.assertThat((Collection)pairCheckLists).hasSize(4);
        Assertions.assertThat((Collection)this.pairCheckStorage.get(this.a)).isEmpty();
        Assertions.assertThat((Collection)this.pairCheckStorage.get(this.b)).isEmpty();
        Assertions.assertThat((Collection)this.pairCheckStorage.get(this.c)).isEmpty();
    }
}

