/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.select;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.select.AllListener;
import org.drools.verifier.core.index.select.FirstListener;
import org.drools.verifier.core.index.select.LastListener;
import org.drools.verifier.core.index.select.Listen;
import org.drools.verifier.core.index.select.Person;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ListenAddToEmptyTest {
    private Listen<Person> listen;
    private MultiMap<Value, Person, List<Person>> map;
    private Collection<Person> all;
    private Person first;
    private Person last;

    @BeforeEach
    public void setUp() throws Exception {
        this.map = MultiMapFactory.make((boolean)true);
        this.listen = new Listen(this.map, (Matcher)new ExactMatcher(KeyDefinition.newKeyDefinition().withId("ID").build(), (Comparable)((Object)"notInTheList"), true));
        this.listen.all((AllListener)new AllListener<Person>(){

            public void onAllChanged(Collection<Person> all) {
                ListenAddToEmptyTest.this.all = all;
            }
        });
        this.listen.first((FirstListener)new FirstListener<Person>(){

            public void onFirstChanged(Person first) {
                ListenAddToEmptyTest.this.first = first;
            }
        });
        this.listen.last((LastListener)new LastListener<Person>(){

            public void onLastChanged(Person last) {
                ListenAddToEmptyTest.this.last = last;
            }
        });
    }

    @Test
    void testEmpty() throws Exception {
        Assertions.assertThat(this.all).isNull();
        Assertions.assertThat((Object)this.first).isNull();
        Assertions.assertThat((Object)this.last).isNull();
    }

    @Test
    void testBeginning() throws Exception {
        Person baby = new Person(0, "baby");
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(0)), (Object)baby);
        Assertions.assertThat((Object)this.first).isEqualTo((Object)baby);
        Assertions.assertThat((Object)this.last).isEqualTo((Object)baby);
        Assertions.assertThat(this.all).hasSize(1);
    }
}

