/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.relations;

import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.relations.IsSubsuming;
import org.drools.verifier.core.relations.RelationResolver;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RelationResolverSubsumptionTest {
    private AnalyzerConfiguration configuration;
    private RelationResolver relationResolver;
    private InspectorList a;
    private InspectorList b;
    private Person firstItemInB;
    private Person blockingItem;

    @BeforeEach
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.a = new InspectorList(this.configuration);
        this.b = new InspectorList(this.configuration);
        this.a.add((HasUUID)new Person(15));
        this.firstItemInB = (Person)Mockito.spy((Object)new Person(15));
        this.b.add((HasUUID)this.firstItemInB);
        this.blockingItem = (Person)Mockito.spy((Object)new Person(10));
        this.b.add((HasUUID)this.blockingItem);
        this.relationResolver = new RelationResolver(this.a, true);
    }

    @Test
    void empty() throws Exception {
        this.relationResolver = new RelationResolver(new InspectorList(this.configuration));
        Assertions.assertThat((boolean)this.relationResolver.subsumes(new InspectorList(this.configuration))).isTrue();
    }

    @Test
    void emptyListWithItemsSubsumesEmptyLists() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.subsumes(new InspectorList(this.configuration))).isTrue();
    }

    @Test
    void recheck() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.subsumes(this.b)).isFalse();
        ((Person)Mockito.verify((Object)this.firstItemInB)).subsumes(Mockito.any());
        Mockito.reset((Object[])new Person[]{this.firstItemInB});
        Assertions.assertThat((boolean)this.relationResolver.subsumes(this.b)).isFalse();
        ((Person)Mockito.verify((Object)this.firstItemInB, (VerificationMode)Mockito.never())).subsumes(Mockito.any());
    }

    @Test
    void recheckWithUpdate() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.subsumes(this.b)).isFalse();
        Mockito.reset((Object[])new Person[]{this.firstItemInB});
        this.blockingItem.setAge(15);
        Assertions.assertThat((boolean)this.relationResolver.subsumes(this.b)).isTrue();
        ((Person)Mockito.verify((Object)this.firstItemInB)).subsumes(Mockito.any());
    }

    @Test
    void recheckConflictingItemRemoved() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.subsumes(this.b)).isFalse();
        Mockito.reset((Object[])new Person[]{this.firstItemInB});
        this.b.remove((Object)this.blockingItem);
        Assertions.assertThat((boolean)this.relationResolver.subsumes(this.b)).isTrue();
        ((Person)Mockito.verify((Object)this.firstItemInB)).subsumes(Mockito.any());
    }

    @Test
    void recheckOtherListBecomesEmpty() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.subsumes(this.b)).isFalse();
        Mockito.reset((Object[])new Person[]{this.firstItemInB, this.blockingItem});
        this.b.clear();
        Assertions.assertThat((boolean)this.relationResolver.subsumes(this.b)).isTrue();
        ((Person)Mockito.verify((Object)this.firstItemInB, (VerificationMode)Mockito.never())).subsumes(Mockito.any());
        ((Person)Mockito.verify((Object)this.blockingItem, (VerificationMode)Mockito.never())).subsumes(Mockito.any());
    }

    public class Person
    implements IsSubsuming,
    HasKeys {
        int age;
        private UUIDKey uuidKey;

        public Person(int age) {
            this.uuidKey = RelationResolverSubsumptionTest.this.configuration.getUUID((HasKeys)this);
            this.age = age;
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey};
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean subsumes(Object other) {
            if (other instanceof Person) {
                return this.age == ((Person)other).age;
            }
            return false;
        }
    }
}

