/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.index.model.Field;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class DoubleComparableConditionInspectorCoverTest {
    @Mock
    private Field field;

    public static Collection<Object[]> testData() {
        return Arrays.asList({0.5, "==", 0.5, true}, {0.5, "<", 0.5, false}, {0.5, "<", 10.5, false}, {10.5, "<", 0.5, true}, {0.5, ">", 0.5, false}, {0.5, ">", 10.5, true}, {10.5, "==", 0.5, false}, {0.5, "==", 10.5, false}, {10.5, ">", 0.5, false}, {-1.5, ">", 0.5, true}, {0.5, ">", -1.5, false}, {-1.5, "==", 0.5, false}, {0.5, "==", -1.5, false}, {new Date(0L), "==", new Date(0L), true}, {new Date(0L), "==", new Date(1L), false}, {new Date(0L), "!=", new Date(0L), false}, {new Date(0L), "!=", new Date(1L), true}, {new Date(0L), "after", new Date(1L), true}, {new Date(1L), "after", new Date(0L), false}, {new Date(0L), "before", new Date(1L), false}, {new Date(1L), "before", new Date(0L), true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest(name="it is {3} that {0} {1} {2}")
    void parametrizedTest(Comparable conditionValue, String conditionOperator, Comparable value, boolean coverExpected) {
        ComparableConditionInspector a = ConditionInspectorUtils.getComparableCondition(this.field, conditionValue, conditionOperator);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.covers(value)).as(this.getAssertDescription(a, value, coverExpected), new Object[0])).isEqualTo(coverExpected);
    }

    private String getAssertDescription(ComparableConditionInspector a, Comparable b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto cover value '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toString());
    }
}

