/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.index.model.Field;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class NumericIntegerConditionInspectorSubsumptionResolverTest {
    @Mock
    private Field field;

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true}, {"!=", 0, "!=", 0, true}, {">", 0, ">", 0, true}, {">=", 0, ">=", 0, true}, {"<", 0, "<", 0, true}, {"<=", 0, "<=", 0, true}, {"==", 0, "==", 1, false}, {"!=", 0, "!=", 1, false}, {">", 0, ">", 1, false}, {">=", 0, ">=", 1, false}, {"<", 0, "<", 1, false}, {"<=", 0, "<=", 1, false}, {"==", 0, "!=", 0, false}, {"==", 0, ">", 0, false}, {"==", 0, ">=", 0, false}, {"==", 0, "<", 0, false}, {"==", 0, "<=", 0, false}, {"!=", 0, ">", 0, false}, {"!=", 0, ">=", 0, false}, {"!=", 0, "<", 0, false}, {"!=", 0, "<=", 0, false}, {">", 0, ">=", 0, false}, {">", 0, "<", 0, false}, {">", 0, "<=", 0, false}, {">=", 0, "<", 0, false}, {">=", 0, "<=", 0, false}, {"<", 0, "<=", 0, false}, {"==", 0, "!=", 1, false}, {"==", 0, ">", 1, false}, {"==", 0, ">=", 1, false}, {"==", 0, "<", 1, false}, {"==", 0, "<=", 1, false}, {"!=", 0, ">", 1, false}, {"!=", 0, ">=", 1, false}, {"!=", 0, "<", 1, false}, {"!=", 0, "<=", 1, false}, {">", 0, ">=", 1, true}, {">", 0, "<", 1, false}, {">", 0, "<=", 1, false}, {">=", 0, "<", 1, false}, {">=", 0, "<=", 1, false}, {"<", 0, "<=", 1, false}, {">", 0, ">=", 1, true}, {"<", 1, "<=", 0, true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedTest(String operator1, Integer value1, String operator2, Integer value2, boolean redundancyExpected) {
        NumericIntegerConditionInspector a = ConditionInspectorUtils.getNumericCondition(this.field, value1, operator1);
        NumericIntegerConditionInspector b = ConditionInspectorUtils.getNumericCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.isRedundant((Object)b)).as(ConditionInspectorUtils.getAssertDescriptionForRedundant((ComparableConditionInspector)a, (ComparableConditionInspector)b, redundancyExpected), new Object[0])).isEqualTo(redundancyExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.isRedundant((Object)a)).as(ConditionInspectorUtils.getAssertDescriptionForRedundant((ComparableConditionInspector)b, (ComparableConditionInspector)a, redundancyExpected), new Object[0])).isEqualTo(redundancyExpected);
    }
}

