/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RulePossibility;
import org.drools.verifier.components.VerifierComponent;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.PartialRedundancy;
import org.drools.verifier.report.components.Redundancy;
import org.drools.verifier.report.components.Subsumption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubsumptantPossibilitiesRuleTest
extends TestBase {
    private static final String RULE_NAME = "Find subsumptant Possibilities";

    public void testFake() {
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)true);
    }

    public void fixmetestSubsumptantPossibilitiesPattern() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("redundancy/Possibilities.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter(RULE_NAME));
        String ruleName1 = "Rule 1";
        String ruleName2 = "Rule 2";
        StatelessSessionResult sessionResult = session.executeWithResults(this.createSubsumptantPatternData(ruleName1, ruleName2));
        Map<String, Set<String>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)TestBase.mapContains(map, ruleName2, ruleName1));
        if (!map.isEmpty()) {
            SubsumptantPossibilitiesRuleTest.fail((String)"More subsumpt cases than was expected.");
        }
    }

    public void fixmetestSubsumptantPossibilitiesRule() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("redundancy/Possibilities.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter(RULE_NAME));
        String ruleName1 = "Rule 1";
        String ruleName2 = "Rule 2";
        StatelessSessionResult sessionResult = session.executeWithResults(this.createSubsumptantRuleData(ruleName1, ruleName2));
        Map<String, Set<String>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)TestBase.mapContains(map, ruleName2, ruleName1));
        if (!map.isEmpty()) {
            SubsumptantPossibilitiesRuleTest.fail((String)"More subsumpt cases than was expected.");
        }
    }

    public void fixmetestSubsumptantPossibilitiesBoth() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("redundancy/Possibilities.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter(RULE_NAME));
        String ruleName1 = "Rule 1";
        String ruleName2 = "Rule 2";
        String ruleName3 = "Rule 3";
        String ruleName4 = "Rule 4";
        String ruleName5 = "Rule 5";
        String ruleName6 = "Rule 6";
        String ruleName7 = "Rule 7";
        String ruleName8 = "Rule 8";
        String ruleName9 = "Rule 9";
        String ruleName10 = "Rule 10";
        String ruleName11 = "Rule 11";
        String ruleName12 = "Rule 12";
        Collection<Object> data = this.createSubsumptantRuleData(ruleName1, ruleName2);
        data.addAll(this.createSubsumptantRuleData(ruleName3, ruleName4));
        data.addAll(this.createSubsumptantRuleData(ruleName5, ruleName6));
        data.addAll(this.createSubsumptantPatternData(ruleName7, ruleName8));
        data.addAll(this.createSubsumptantPatternData(ruleName9, ruleName10));
        data.addAll(this.createSubsumptantPatternData(ruleName11, ruleName12));
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<String, Set<String>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)TestBase.mapContains(map, ruleName2, ruleName1));
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)TestBase.mapContains(map, ruleName4, ruleName3));
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)TestBase.mapContains(map, ruleName6, ruleName5));
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)TestBase.mapContains(map, ruleName8, ruleName7));
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)TestBase.mapContains(map, ruleName10, ruleName9));
        SubsumptantPossibilitiesRuleTest.assertTrue((boolean)TestBase.mapContains(map, ruleName12, ruleName11));
        if (!map.isEmpty()) {
            SubsumptantPossibilitiesRuleTest.fail((String)"More subsumpt cases than was expected.");
        }
    }

    private Collection<Object> createSubsumptantPatternData(String ruleName1, String ruleName2) {
        ArrayList<Object> data = new ArrayList<Object>();
        LiteralRestriction lr1 = new LiteralRestriction();
        lr1.setRuleName(ruleName1);
        LiteralRestriction lr2 = new LiteralRestriction();
        lr2.setRuleName(ruleName1);
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setRuleName(ruleName1);
        pp1.add((Restriction)lr1);
        pp1.add((Restriction)lr2);
        LiteralRestriction lr3 = new LiteralRestriction();
        lr3.setRuleName(ruleName2);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setRuleName(ruleName2);
        pp2.add((Restriction)lr3);
        Redundancy redundancy1 = new Redundancy((Cause)lr1, (Cause)lr3);
        PartialRedundancy pr1 = new PartialRedundancy((Cause)pp1, (Cause)pp2, redundancy1);
        PartialRedundancy pr2 = new PartialRedundancy((Cause)pp2, (Cause)pp1, redundancy1);
        data.add(lr1);
        data.add(lr2);
        data.add(lr3);
        data.add(pp1);
        data.add(pp2);
        data.add(redundancy1);
        data.add(pr1);
        data.add(pr2);
        return data;
    }

    private Collection<Object> createSubsumptantRuleData(String ruleName1, String ruleName2) {
        ArrayList<Object> data = new ArrayList<Object>();
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setRuleName(ruleName1);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setRuleName(ruleName1);
        RulePossibility rp1 = new RulePossibility();
        rp1.setRuleName(ruleName1);
        rp1.add(pp1);
        rp1.add(pp2);
        PatternPossibility pp3 = new PatternPossibility();
        pp3.setRuleName(ruleName2);
        RulePossibility rp2 = new RulePossibility();
        rp2.setRuleName(ruleName2);
        rp2.add(pp3);
        Redundancy redundancy1 = new Redundancy((Cause)pp1, (Cause)pp3);
        PartialRedundancy pr1 = new PartialRedundancy((Cause)rp1, (Cause)rp2, redundancy1);
        PartialRedundancy pr2 = new PartialRedundancy((Cause)rp2, (Cause)rp1, redundancy1);
        data.add(pp1);
        data.add(pp2);
        data.add(rp1);
        data.add(pp3);
        data.add(rp2);
        data.add(redundancy1);
        data.add(pr1);
        data.add(pr2);
        return data;
    }

    private Map<String, Set<String>> createSubsumptionMap(Iterator iter) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        while (iter.hasNext()) {
            Set<String> set;
            Object o = iter.next();
            if (!(o instanceof Subsumption)) continue;
            Subsumption s = (Subsumption)o;
            VerifierComponent left = (VerifierComponent)s.getLeft();
            VerifierComponent right = (VerifierComponent)s.getRight();
            if (map.containsKey(left.getRuleName())) {
                set = (Set)map.get(left.getRuleName());
                set.add(right.getRuleName());
                continue;
            }
            set = new HashSet<String>();
            set.add(right.getRuleName());
            map.put(left.getRuleName(), set);
        }
        return map;
    }
}

