/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.optimisation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.base.evaluators.Operator;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.OperatorDescr;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.VerifierComponent;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;

public class RestrictionOrderTest
extends TestBase {
    public void testRestrictionOrderInsideOperator() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionOrder.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Optimise restrictions inside operator"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("OptimisationRestrictionOrderTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            String name = ((VerifierMessage)o).getCauses().toArray(new Restriction[2])[0].getRuleName();
            ruleNames.add(name);
        }
        RestrictionOrderTest.assertTrue((boolean)ruleNames.remove("Wrong descr order 1"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                RestrictionOrderTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testRestrictionOrderInsideConstraint() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionOrder.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Optimise restrictions inside constraint"));
        ArrayList<Object> testData = new ArrayList<Object>();
        Pattern pattern1 = new Pattern();
        testData.add(pattern1);
        OperatorDescr parent1 = new OperatorDescr(OperatorDescr.Type.AND);
        LiteralRestriction r1 = new LiteralRestriction();
        r1.setPatternId(pattern1.getId());
        r1.setParent((VerifierComponent)parent1);
        r1.setOperator(Operator.GREATER);
        r1.setOrderNumber(1);
        testData.add(r1);
        LiteralRestriction r2 = new LiteralRestriction();
        r2.setPatternId(pattern1.getId());
        r2.setParent((VerifierComponent)parent1);
        r2.setOperator(Operator.EQUAL);
        r2.setOrderNumber(2);
        testData.add(r2);
        LiteralRestriction r3 = new LiteralRestriction();
        r3.setPatternId(pattern1.getId());
        r3.setParent((VerifierComponent)parent1);
        r3.setOperator(Operator.LESS);
        r3.setOrderNumber(3);
        testData.add(r3);
        Pattern pattern2 = new Pattern();
        testData.add(pattern2);
        OperatorDescr parent2 = new OperatorDescr(OperatorDescr.Type.OR);
        LiteralRestriction r4 = new LiteralRestriction();
        r4.setPatternId(pattern2.getId());
        r4.setParent((VerifierComponent)parent2);
        r4.setOperator(Operator.NOT_EQUAL);
        r4.setOrderNumber(1);
        testData.add(r4);
        LiteralRestriction r5 = new LiteralRestriction();
        r5.setPatternId(pattern2.getId());
        r5.setParent((VerifierComponent)parent2);
        r5.setOperator(Operator.LESS_OR_EQUAL);
        r5.setOrderNumber(2);
        testData.add(r5);
        LiteralRestriction r6 = new LiteralRestriction();
        r6.setPatternId(pattern2.getId());
        r6.setParent((VerifierComponent)parent2);
        r6.setOperator(Operator.NOT_EQUAL);
        r6.setOrderNumber(3);
        testData.add(r6);
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        HashMap<Cause, Cause> pairs = new HashMap<Cause, Cause>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause left = ((VerifierMessage)o).getCauses().toArray(new Cause[2])[0];
            Cause right = ((VerifierMessage)o).getCauses().toArray(new Cause[2])[1];
            pairs.put(left, right);
        }
        RestrictionOrderTest.assertTrue((pairs.containsKey(r1) && ((Cause)pairs.get(r1)).equals(r2) || pairs.containsKey(r2) && ((Cause)pairs.get(r2)).equals(r1) ? 1 : 0) != 0);
        RestrictionOrderTest.assertTrue((pairs.containsKey(r4) && ((Cause)pairs.get(r4)).equals(r5) || pairs.containsKey(r5) && ((Cause)pairs.get(r5)).equals(r4) ? 1 : 0) != 0);
        RestrictionOrderTest.assertEquals((int)2, (int)pairs.size());
    }

    public void testPredicateOrderInsideOperator() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionOrder.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Optimise predicates inside operator"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("OptimisationRestrictionOrderTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            String name = ((VerifierMessage)o).getCauses().toArray(new VerifierComponent[2])[0].getRuleName();
            ruleNames.add(name);
        }
        RestrictionOrderTest.assertTrue((boolean)ruleNames.remove("Wrong eval order 1"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                RestrictionOrderTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

