/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.redundancy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.VerifierComponent;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.CauseType;
import org.drools.verifier.report.components.Redundancy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedundancyTestBase
extends TestBase {
    protected Map<String, Set<String>> createRedundancyMap(Iterator<Object> iter) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        while (iter.hasNext()) {
            Set<String> set;
            Object o = iter.next();
            if (!(o instanceof Redundancy)) continue;
            Redundancy r = (Redundancy)o;
            VerifierComponent left = (VerifierComponent)r.getLeft();
            VerifierComponent right = (VerifierComponent)r.getRight();
            if (map.containsKey(left.getRuleName())) {
                set = (Set)map.get(left.getRuleName());
                set.add(right.getRuleName());
                continue;
            }
            set = new HashSet<String>();
            set.add(right.getRuleName());
            map.put(left.getRuleName(), set);
        }
        return map;
    }

    protected Map<Cause, Set<Cause>> createRedundancyCauseMap(CauseType type, Iterator<Object> iter) {
        HashMap<Cause, Set<Cause>> map = new HashMap<Cause, Set<Cause>>();
        while (iter.hasNext()) {
            Set<Cause> set;
            Redundancy r;
            Object o = iter.next();
            if (!(o instanceof Redundancy) || (r = (Redundancy)o).getLeft().getCauseType() != type) continue;
            Cause left = r.getLeft();
            Cause right = r.getRight();
            if (map.containsKey(left)) {
                set = (Set)map.get(left);
                set.add(right);
                continue;
            }
            set = new HashSet();
            set.add(right);
            map.put(left, set);
        }
        return map;
    }

    public void testDummy() {
    }

    protected static boolean mapContains(Map<String, Set<Redundancy>> map, String key, Object value) {
        if (map.containsKey(key)) {
            Set<Redundancy> set = map.get(key);
            boolean exists = set.remove(value);
            if (set.isEmpty()) {
                map.remove(key);
            }
            return exists;
        }
        return false;
    }
}

