/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.redundancy;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.RulePossibility;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Redundancy;
import org.drools.verifier.report.components.RedundancyType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

public class WarningsTest
extends TestBase {
    public void testRedundantRules() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Warnings.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find redundant rule possibilities from different rules"));
        ArrayList<Object> objects = new ArrayList<Object>();
        VerifierRule rule1 = new VerifierRule();
        VerifierRule rule2 = new VerifierRule();
        Redundancy ruleRedundancy = new Redundancy(RedundancyType.STRONG, (Cause)rule1, (Cause)rule2);
        RulePossibility rp1 = new RulePossibility();
        rp1.setRuleId(rule1.getId());
        RulePossibility rp2 = new RulePossibility();
        rp2.setRuleId(rule2.getId());
        Redundancy rulePossibilityRedundancy1 = new Redundancy(RedundancyType.STRONG, (Cause)rp1, (Cause)rp2);
        Redundancy rulePossibilityRedundancy2 = new Redundancy(RedundancyType.STRONG, (Cause)rp2, (Cause)rp1);
        objects.add(rule1);
        objects.add(rule2);
        objects.add(ruleRedundancy);
        objects.add(rp1);
        objects.add(rp2);
        objects.add(rulePossibilityRedundancy1);
        objects.add(rulePossibilityRedundancy2);
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        session.executeWithResults(objects);
        Collection notes = result.getBySeverity(Severity.WARNING);
        WarningsTest.assertEquals((int)1, (int)notes.size());
        VerifierMessageBase warning = (VerifierMessageBase)notes.iterator().next();
        WarningsTest.assertTrue((boolean)warning.getFaulty().equals(rulePossibilityRedundancy1));
    }

    public void testSubsumptantRules() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Warnings.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find subsumptant rule possibilities from different rules"));
        ArrayList<Object> objects = new ArrayList<Object>();
        VerifierRule rule1 = new VerifierRule();
        VerifierRule rule2 = new VerifierRule();
        Redundancy ruleRedundancy = new Redundancy(RedundancyType.STRONG, (Cause)rule1, (Cause)rule2);
        RulePossibility rp1 = new RulePossibility();
        rp1.setRuleId(rule1.getId());
        RulePossibility rp2 = new RulePossibility();
        rp2.setRuleId(rule2.getId());
        Redundancy rulePossibilityRedundancy1 = new Redundancy(RedundancyType.STRONG, (Cause)rp1, (Cause)rp2);
        objects.add(rule1);
        objects.add(rule2);
        objects.add(ruleRedundancy);
        objects.add(rp1);
        objects.add(rp2);
        objects.add(rulePossibilityRedundancy1);
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        session.executeWithResults(objects);
        Collection notes = result.getBySeverity(Severity.WARNING);
        WarningsTest.assertEquals((int)1, (int)notes.size());
        VerifierMessageBase warning = (VerifierMessageBase)notes.iterator().next();
        WarningsTest.assertTrue((boolean)warning.getFaulty().equals(rulePossibilityRedundancy1));
    }
}

