/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.drools.base.evaluators.Operator;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.dao.DataTree;
import org.drools.verifier.dao.VerifierData;
import org.drools.verifier.report.components.RangeCheckCause;
import org.drools.verifier.report.components.VerifierRangeCheckMessage;
import org.drools.verifier.report.html.DataRow;
import org.drools.verifier.report.html.ReportVisitor;
import org.drools.verifier.report.html.UrlFactory;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MissingRangesReportVisitor
extends ReportVisitor {
    MissingRangesReportVisitor() {
    }

    public static Collection<String> visitRestrictionsCollection(String sourceFolder, Collection<Restriction> restrictions, Collection<RangeCheckCause> causes) {
        DataTree<Object, DataRow> dt = new DataTree<Object, DataRow>();
        ArrayList<String> stringRows = new ArrayList<String>();
        for (RangeCheckCause cause : causes) {
            dt.put(cause.getValueAsObject(), new DataRow(null, null, cause.getOperator(), cause.getValueAsString()));
        }
        for (Restriction r : restrictions) {
            if (!(r instanceof LiteralRestriction)) continue;
            try {
                LiteralRestriction restriction = (LiteralRestriction)r;
                dt.put(restriction.getValueAsObject(), new DataRow(restriction.getRuleId(), restriction.getRuleName(), restriction.getOperator(), restriction.getValueAsString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DataRow previous = null;
        Iterator iterator = dt.values().iterator();
        while (iterator.hasNext()) {
            DataRow current = (DataRow)iterator.next();
            if (previous != null) {
                if (!(previous.ruleId != null || current.ruleId != null || previous.operator.equals((Object)Operator.EQUAL) || previous.operator.equals((Object)Operator.NOT_EQUAL) || current.operator.equals((Object)Operator.EQUAL) || current.operator.equals((Object)Operator.NOT_EQUAL))) {
                    stringRows.add("Missing : " + previous + " .. " + current);
                    current = (DataRow)iterator.next();
                } else if (previous.ruleId != null && previous.ruleId.equals(current.ruleId)) {
                    stringRows.add(UrlFactory.getRuleUrl(sourceFolder, current.ruleId, current.ruleName) + " : " + previous.toString() + " " + current.toString());
                    current = (DataRow)iterator.next();
                } else if (!iterator.hasNext()) {
                    MissingRangesReportVisitor.processRangeOutput(previous, stringRows, sourceFolder);
                    MissingRangesReportVisitor.processRangeOutput(current, stringRows, sourceFolder);
                } else {
                    MissingRangesReportVisitor.processRangeOutput(previous, stringRows, sourceFolder);
                }
            } else if (!iterator.hasNext()) {
                MissingRangesReportVisitor.processRangeOutput(current, stringRows, sourceFolder);
            }
            previous = current;
        }
        return stringRows;
    }

    public static String visitRanges(String sourceFolder, Collection<Restriction> restrictions, Collection<RangeCheckCause> causes) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        map.put("lines", MissingRangesReportVisitor.visitRestrictionsCollection(sourceFolder, restrictions, causes));
        String myTemplate = MissingRangesReportVisitor.readFile("ranges.htm");
        String result = String.valueOf(TemplateRuntime.eval((String)myTemplate, map));
        return result;
    }

    private static void processRangeOutput(DataRow dataRow, Collection<String> stringRows, String sourceFolder) {
        if (dataRow.ruleId == null) {
            stringRows.add("Missing : " + dataRow.toString());
        } else {
            stringRows.add(UrlFactory.getRuleUrl(sourceFolder, dataRow.ruleId, dataRow.ruleName) + " : " + dataRow.toString());
        }
    }

    public static String visitRangeCheckMessage(String sourceFolder, VerifierRangeCheckMessage message, VerifierData data) {
        Collection<Restriction> restrictions = data.getRestrictionsByFieldId(message.getFaulty().getId());
        Field field = (Field)message.getFaulty();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", MissingRangesReportVisitor.processHeader(sourceFolder));
        map.put("sourceFolder", sourceFolder);
        map.put("fieldFolder", sourceFolder + "/" + "fields");
        map.put("objectTypeFolder", sourceFolder + "/" + "objectTypes");
        map.put("packageFolder", sourceFolder + "/" + "packages");
        map.put("cssStyle", MissingRangesReportVisitor.createStyleTag(sourceFolder + "/" + "css" + "/" + "basic.css"));
        map.put("field", field);
        map.put("objectType", data.getObjectTypeById(field.getObjectTypeId()));
        map.put("ranges", MissingRangesReportVisitor.visitRanges(".", restrictions, message.getCauses()));
        String myTemplate = MissingRangesReportVisitor.readFile("missingRange.htm");
        String result = String.valueOf(TemplateRuntime.eval((String)myTemplate, map));
        return result;
    }
}

