/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.drools.verifier.PatternSolver;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.OperatorDescr;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.VerifierComponent;

public class PatternSolverTest
extends TestCase {
    public void testAddBasicAnd() {
        Pattern pattern = new Pattern();
        LiteralRestriction literalRestriction = new LiteralRestriction();
        LiteralRestriction literalRestriction2 = new LiteralRestriction();
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescr.Type.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        List list = solver.getPossibilityLists();
        PatternSolverTest.assertEquals((int)1, (int)list.size());
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(0)).size());
    }

    public void testAddBasicOr() {
        Pattern pattern = new Pattern();
        LiteralRestriction literalRestriction = new LiteralRestriction();
        LiteralRestriction literalRestriction2 = new LiteralRestriction();
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescr.Type.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        List list = solver.getPossibilityLists();
        PatternSolverTest.assertEquals((int)2, (int)list.size());
        PatternSolverTest.assertEquals((int)1, (int)((Set)list.get(0)).size());
        PatternSolverTest.assertEquals((int)1, (int)((Set)list.get(1)).size());
    }

    public void testAddOrAnd() {
        Pattern pattern = new Pattern();
        LiteralRestriction literalRestriction = new LiteralRestriction();
        LiteralRestriction literalRestriction2 = new LiteralRestriction();
        LiteralRestriction literalRestriction3 = new LiteralRestriction();
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescr.Type.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.addOperator(OperatorDescr.Type.AND);
        solver.add((VerifierComponent)literalRestriction2);
        solver.add((VerifierComponent)literalRestriction3);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        PatternSolverTest.assertEquals((int)2, (int)list.size());
        PatternSolverTest.assertEquals((int)1, (int)((Set)list.get(0)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(1)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction2));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction3));
    }

    public void testAddAndOr() {
        Pattern pattern = new Pattern();
        LiteralRestriction literalRestriction = new LiteralRestriction();
        LiteralRestriction literalRestriction2 = new LiteralRestriction();
        LiteralRestriction literalRestriction3 = new LiteralRestriction();
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescr.Type.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.addOperator(OperatorDescr.Type.OR);
        solver.add((VerifierComponent)literalRestriction2);
        solver.add((VerifierComponent)literalRestriction3);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        PatternSolverTest.assertEquals((int)2, (int)list.size());
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(0)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction2));
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(1)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction3));
    }

    public void testAddAndOrOr() {
        Pattern pattern = new Pattern();
        LiteralRestriction literalRestriction = new LiteralRestriction();
        LiteralRestriction literalRestriction2 = new LiteralRestriction();
        LiteralRestriction literalRestriction3 = new LiteralRestriction();
        LiteralRestriction literalRestriction4 = new LiteralRestriction();
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescr.Type.AND);
        solver.addOperator(OperatorDescr.Type.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescr.Type.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        PatternSolverTest.assertEquals((int)4, (int)list.size());
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(0)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction3));
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(1)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction4));
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(2)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(2)).contains(literalRestriction2));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(2)).contains(literalRestriction3));
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(3)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(3)).contains(literalRestriction2));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(3)).contains(literalRestriction4));
    }

    public void testAddOrAndAnd() {
        Pattern pattern = new Pattern();
        LiteralRestriction literalRestriction = new LiteralRestriction();
        LiteralRestriction literalRestriction2 = new LiteralRestriction();
        LiteralRestriction literalRestriction3 = new LiteralRestriction();
        LiteralRestriction literalRestriction4 = new LiteralRestriction();
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescr.Type.OR);
        solver.addOperator(OperatorDescr.Type.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescr.Type.AND);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        PatternSolverTest.assertEquals((int)2, (int)list.size());
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(0)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction2));
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(1)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction3));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction4));
    }

    public void testAddOrAndOr() {
        Pattern pattern = new Pattern();
        LiteralRestriction literalRestriction = new LiteralRestriction();
        LiteralRestriction literalRestriction2 = new LiteralRestriction();
        LiteralRestriction literalRestriction3 = new LiteralRestriction();
        LiteralRestriction literalRestriction4 = new LiteralRestriction();
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescr.Type.OR);
        solver.addOperator(OperatorDescr.Type.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescr.Type.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        PatternSolverTest.assertEquals((int)3, (int)list.size());
        PatternSolverTest.assertEquals((int)2, (int)((Set)list.get(0)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction2));
        PatternSolverTest.assertEquals((int)1, (int)((Set)list.get(1)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction3));
        PatternSolverTest.assertEquals((int)1, (int)((Set)list.get(2)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(2)).contains(literalRestriction4));
    }

    public void testAddOrAndOrDescr() {
        Pattern pattern = new Pattern();
        LiteralRestriction literalRestriction = new LiteralRestriction();
        LiteralRestriction literalRestriction2 = new LiteralRestriction();
        LiteralRestriction literalRestriction3 = new LiteralRestriction();
        LiteralRestriction literalRestriction4 = new LiteralRestriction();
        LiteralRestriction literalRestriction5 = new LiteralRestriction();
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescr.Type.AND);
        solver.addOperator(OperatorDescr.Type.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescr.Type.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.add((VerifierComponent)literalRestriction5);
        solver.end();
        List list = solver.getPossibilityLists();
        PatternSolverTest.assertEquals((int)2, (int)list.size());
        PatternSolverTest.assertEquals((int)4, (int)((Set)list.get(0)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction2));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction3));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(0)).contains(literalRestriction5));
        PatternSolverTest.assertEquals((int)4, (int)((Set)list.get(1)).size());
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction2));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction4));
        PatternSolverTest.assertTrue((boolean)((Set)list.get(1)).contains(literalRestriction4));
    }
}

