/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.alwaysFalse;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RulePossibility;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Incompatibility;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;

public class AlwaysFalseTest
extends TestBase {
    public void testPatterns() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Pattern that is always false"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = new VerifierRule();
        Pattern pattern1 = new Pattern();
        pattern1.setRuleId(rule1.getId());
        LiteralRestriction r1 = new LiteralRestriction();
        LiteralRestriction r2 = new LiteralRestriction();
        Incompatibility i1 = new Incompatibility((Cause)r1, (Cause)r2);
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setPatternId(pattern1.getId());
        pp1.add((Restriction)r1);
        pp1.add((Restriction)r2);
        VariableRestriction r3 = new VariableRestriction();
        VariableRestriction r4 = new VariableRestriction();
        Incompatibility i2 = new Incompatibility((Cause)r1, (Cause)r2);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setPatternId(pattern1.getId());
        pp2.add((Restriction)r1);
        pp2.add((Restriction)r2);
        Pattern pattern2 = new Pattern();
        pattern2.setRuleId(rule1.getId());
        LiteralRestriction r5 = new LiteralRestriction();
        LiteralRestriction r6 = new LiteralRestriction();
        PatternPossibility pp3 = new PatternPossibility();
        pp3.setPatternId(pattern2.getId());
        pp3.add((Restriction)r5);
        pp3.add((Restriction)r6);
        VariableRestriction r7 = new VariableRestriction();
        VariableRestriction r8 = new VariableRestriction();
        Incompatibility i4 = new Incompatibility((Cause)r7, (Cause)r8);
        PatternPossibility pp4 = new PatternPossibility();
        pp4.setPatternId(pattern2.getId());
        pp4.add((Restriction)r7);
        pp4.add((Restriction)r8);
        data.add(rule1);
        data.add(pattern1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(i1);
        data.add(i2);
        data.add(pp1);
        data.add(pp2);
        data.add(pattern2);
        data.add(r5);
        data.add(r6);
        data.add(r7);
        data.add(r8);
        data.add(i4);
        data.add(pp3);
        data.add(pp4);
        session.executeWithResults(data);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        boolean works = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            if (message.getFaulty().equals(pattern1)) {
                works = true;
                continue;
            }
            AlwaysFalseTest.fail((String)"There can be only one. (And this is not the one)");
        }
        AlwaysFalseTest.assertEquals((int)1, (int)result.getBySeverity(Severity.ERROR).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.NOTE).size());
        AlwaysFalseTest.assertTrue((boolean)works);
    }

    public void testSinglePatternNoRestrictions() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Pattern that is always false"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = new VerifierRule();
        Pattern pattern1 = new Pattern();
        pattern1.setRuleId(rule1.getId());
        data.add(rule1);
        data.add(pattern1);
        session.executeWithResults(data);
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.NOTE).size());
    }

    public void testRules() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Rules.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Rule that is always false"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = new VerifierRule();
        PatternPossibility pp1 = new PatternPossibility();
        PatternPossibility pp2 = new PatternPossibility();
        Incompatibility i1 = new Incompatibility((Cause)pp1, (Cause)pp2);
        RulePossibility rp1 = new RulePossibility();
        rp1.setRuleId(rule1.getId());
        rp1.add(pp1);
        rp1.add(pp2);
        PatternPossibility pp3 = new PatternPossibility();
        PatternPossibility pp4 = new PatternPossibility();
        Incompatibility i2 = new Incompatibility((Cause)pp1, (Cause)pp2);
        RulePossibility rp2 = new RulePossibility();
        rp2.setRuleId(rule1.getId());
        rp2.add(pp1);
        rp2.add(pp2);
        VerifierRule rule2 = new VerifierRule();
        PatternPossibility pp5 = new PatternPossibility();
        PatternPossibility pp6 = new PatternPossibility();
        RulePossibility rp3 = new RulePossibility();
        rp3.setRuleId(rule2.getId());
        rp3.add(pp5);
        rp3.add(pp6);
        PatternPossibility pp7 = new PatternPossibility();
        PatternPossibility pp8 = new PatternPossibility();
        Incompatibility i4 = new Incompatibility((Cause)pp7, (Cause)pp8);
        RulePossibility rp4 = new RulePossibility();
        rp4.setRuleId(rule2.getId());
        rp4.add(pp7);
        rp4.add(pp8);
        data.add(rule1);
        data.add(pp1);
        data.add(pp2);
        data.add(pp3);
        data.add(pp4);
        data.add(i1);
        data.add(i2);
        data.add(rp1);
        data.add(rp2);
        data.add(rule2);
        data.add(pp5);
        data.add(pp6);
        data.add(pp7);
        data.add(pp8);
        data.add(i4);
        data.add(rp3);
        data.add(rp4);
        session.executeWithResults(data);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        boolean works = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            if (message.getFaulty().equals(rule1)) {
                works = true;
                continue;
            }
            AlwaysFalseTest.fail((String)"There can be only one. (And this is not the one)");
        }
        AlwaysFalseTest.assertEquals((int)1, (int)result.getBySeverity(Severity.ERROR).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.NOTE).size());
        AlwaysFalseTest.assertTrue((boolean)works);
    }
}

