/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.alwaysTrue;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.AlwaysTrue;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Opposites;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;

public class AlwaysTruePatternTest
extends TestBase {
    public void testPatternPossibilities() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Pattern possibility that is always true"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        Pattern pattern1 = new Pattern();
        LiteralRestriction r1 = new LiteralRestriction();
        LiteralRestriction r2 = new LiteralRestriction();
        Opposites o1 = new Opposites((Cause)r1, (Cause)r2);
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setPatternId(pattern1.getId());
        pp1.add((Restriction)r1);
        pp1.add((Restriction)r2);
        VariableRestriction r3 = new VariableRestriction();
        VariableRestriction r4 = new VariableRestriction();
        Opposites o2 = new Opposites((Cause)r1, (Cause)r2);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setPatternId(pattern1.getId());
        pp2.add((Restriction)r1);
        pp2.add((Restriction)r2);
        Pattern pattern2 = new Pattern();
        LiteralRestriction r5 = new LiteralRestriction();
        LiteralRestriction r6 = new LiteralRestriction();
        PatternPossibility pp3 = new PatternPossibility();
        pp3.setPatternId(pattern2.getId());
        pp3.add((Restriction)r5);
        pp3.add((Restriction)r6);
        VariableRestriction r7 = new VariableRestriction();
        VariableRestriction r8 = new VariableRestriction();
        Opposites o4 = new Opposites((Cause)r7, (Cause)r8);
        PatternPossibility pp4 = new PatternPossibility();
        pp4.setPatternId(pattern2.getId());
        pp4.add((Restriction)r7);
        pp4.add((Restriction)r8);
        data.add(pattern1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(o1);
        data.add(o2);
        data.add(pp1);
        data.add(pp2);
        data.add(pattern2);
        data.add(r5);
        data.add(r6);
        data.add(r7);
        data.add(r8);
        data.add(o4);
        data.add(pp3);
        data.add(pp4);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Iterator iter = sessionResult.iterateObjects();
        boolean pp1true = false;
        boolean pp2true = false;
        boolean pp3true = false;
        boolean pp4true = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof AlwaysTrue)) continue;
            AlwaysTrue alwaysTrue = (AlwaysTrue)o;
            if (!pp1true) {
                pp1true = alwaysTrue.getCause().equals(pp1);
            }
            if (!pp2true) {
                pp2true = alwaysTrue.getCause().equals(pp2);
            }
            if (!pp3true) {
                pp3true = alwaysTrue.getCause().equals(pp3);
            }
            if (pp4true) continue;
            pp4true = alwaysTrue.getCause().equals(pp4);
        }
        AlwaysTruePatternTest.assertTrue((boolean)pp1true);
        AlwaysTruePatternTest.assertTrue((boolean)pp2true);
        AlwaysTruePatternTest.assertFalse((boolean)pp3true);
        AlwaysTruePatternTest.assertTrue((boolean)pp4true);
    }

    public void testPatterns() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Pattern that is always true"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = new VerifierRule();
        Pattern pattern1 = new Pattern();
        pattern1.setRuleId(rule1.getId());
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setPatternId(pattern1.getId());
        AlwaysTrue alwaysTrue1 = new AlwaysTrue((Cause)pp1);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setPatternId(pattern1.getId());
        AlwaysTrue alwaysTrue2 = new AlwaysTrue((Cause)pp2);
        Pattern pattern2 = new Pattern();
        pattern2.setRuleId(rule1.getId());
        PatternPossibility pp3 = new PatternPossibility();
        pp3.setPatternId(pattern2.getId());
        PatternPossibility pp4 = new PatternPossibility();
        pp4.setPatternId(pattern2.getId());
        AlwaysTrue alwaysTrue4 = new AlwaysTrue((Cause)pp4);
        data.add(rule1);
        data.add(pattern1);
        data.add(pp1);
        data.add(pp2);
        data.add(alwaysTrue1);
        data.add(alwaysTrue2);
        data.add(pattern2);
        data.add(pp3);
        data.add(pp4);
        data.add(alwaysTrue4);
        session.executeWithResults(data);
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        boolean works = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            if (message.getFaulty().equals(pattern1)) {
                works = true;
                continue;
            }
            AlwaysTruePatternTest.fail((String)"There can be only one. (And this is not the one)");
        }
        AlwaysTruePatternTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        AlwaysTruePatternTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        AlwaysTruePatternTest.assertEquals((int)1, (int)result.getBySeverity(Severity.NOTE).size());
        AlwaysTruePatternTest.assertTrue((boolean)works);
    }
}

