/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.missingEquality;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;

public class MissingEqualityTest
extends TestBase {
    public void testMissingEqualityInLiteralRestrictions() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("MissingEquality.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in LiteralRestrictions"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((LiteralRestriction)cause).getRuleName();
            ruleNames.add(name);
        }
        MissingEqualityTest.assertTrue((boolean)ruleNames.remove("Missing equality 1"));
        MissingEqualityTest.assertTrue((boolean)ruleNames.remove("Missing equality 2"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                MissingEqualityTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testMissingEqualityInVariableRestrictions() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("MissingEquality.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in VariableRestrictions"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((VariableRestriction)cause).getRuleName();
            ruleNames.add(name);
        }
        MissingEqualityTest.assertTrue((boolean)ruleNames.remove("Missing equality 3"));
        MissingEqualityTest.assertTrue((boolean)ruleNames.remove("Missing equality 4"));
        MissingEqualityTest.assertTrue((boolean)ruleNames.remove("Missing equality 5"));
        MissingEqualityTest.assertTrue((boolean)ruleNames.remove("Missing equality 6"));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                MissingEqualityTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

