/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.overlaps;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.base.evaluators.Operator;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.VerifierComponent;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.Subsumption;
import org.drools.verifier.report.components.VerifierMessage;

public class OverlappingRestrictionsTest
extends TestBase {
    public void testOverlap() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find overlapping restrictions"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        ArrayList<Object> data = new ArrayList<Object>();
        String ruleName1 = "Rule 1";
        Field field1 = new Field();
        LiteralRestriction lr1 = new LiteralRestriction();
        lr1.setRuleName(ruleName1);
        lr1.setFieldId(field1.getId());
        lr1.setValue("1.0");
        lr1.setOperator(Operator.GREATER);
        LiteralRestriction lr2 = new LiteralRestriction();
        lr2.setRuleName(ruleName1);
        lr2.setFieldId(field1.getId());
        lr2.setValue("2.0");
        lr2.setOperator(Operator.GREATER);
        Subsumption s1 = new Subsumption((Cause)lr1, (Cause)lr2);
        String ruleName2 = "Rule 2";
        Field field2 = new Field();
        LiteralRestriction lr3 = new LiteralRestriction();
        lr3.setRuleName(ruleName2);
        lr3.setFieldId(field2.getId());
        lr3.setValue("1.0");
        lr3.setOperator(Operator.GREATER);
        LiteralRestriction lr4 = new LiteralRestriction();
        lr4.setRuleName(ruleName2);
        lr4.setFieldId(field2.getId());
        lr4.setValue("2.0");
        lr4.setOperator(Operator.GREATER);
        LiteralRestriction lr5 = new LiteralRestriction();
        lr5.setRuleName(ruleName2);
        lr5.setFieldId(field2.getId());
        lr5.setValue("1.5");
        lr5.setOperator(Operator.LESS);
        Subsumption s2 = new Subsumption((Cause)lr3, (Cause)lr4);
        data.add(lr1);
        data.add(lr2);
        data.add(lr3);
        data.add(lr4);
        data.add(lr5);
        data.add(s1);
        data.add(s2);
        session.setGlobal("result", (Object)result);
        session.executeWithResults(data);
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        ArrayList<String> ruleNames = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            String name = ((VerifierMessage)o).getCauses().toArray(new VerifierComponent[2])[0].getRuleName();
            ruleNames.add(name);
        }
        OverlappingRestrictionsTest.assertTrue((boolean)ruleNames.remove(ruleName1));
        OverlappingRestrictionsTest.assertFalse((boolean)ruleNames.remove(ruleName2));
        if (!ruleNames.isEmpty()) {
            for (String string : ruleNames) {
                OverlappingRestrictionsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

