/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.redundancy;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RulePossibility;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Redundancy;
import org.drools.verifier.report.components.RedundancyType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

public class NotesTest
extends TestBase {
    public void testRedundantRestrictionsInPatternPossibilities() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Notes.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find redundant restrictions from pattern possibilities"));
        ArrayList<Object> objects = new ArrayList<Object>();
        LiteralRestriction left = new LiteralRestriction();
        LiteralRestriction right = new LiteralRestriction();
        Redundancy redundancy = new Redundancy(RedundancyType.STRONG, (Cause)left, (Cause)right);
        PatternPossibility possibility = new PatternPossibility();
        possibility.add((Restriction)left);
        possibility.add((Restriction)right);
        objects.add(left);
        objects.add(right);
        objects.add(redundancy);
        objects.add(possibility);
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        session.executeWithResults(objects);
        Collection notes = result.getBySeverity(Severity.NOTE);
        NotesTest.assertEquals((int)1, (int)notes.size());
        VerifierMessageBase note = (VerifierMessageBase)notes.iterator().next();
        NotesTest.assertTrue((boolean)note.getFaulty().equals(redundancy));
    }

    public void testRedundantPatternPossibilitiesInRulePossibilities() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Notes.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find redundant pattern possibilities from rule possibilities"));
        ArrayList<Object> objects = new ArrayList<Object>();
        PatternPossibility left = new PatternPossibility();
        PatternPossibility right = new PatternPossibility();
        Redundancy redundancy = new Redundancy(RedundancyType.STRONG, (Cause)left, (Cause)right);
        RulePossibility possibility = new RulePossibility();
        possibility.add(left);
        possibility.add(right);
        objects.add(left);
        objects.add(right);
        objects.add(redundancy);
        objects.add(possibility);
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        session.executeWithResults(objects);
        Collection notes = result.getBySeverity(Severity.NOTE);
        NotesTest.assertEquals((int)1, (int)notes.size());
        VerifierMessageBase note = (VerifierMessageBase)notes.iterator().next();
        NotesTest.assertTrue((boolean)note.getFaulty().equals(redundancy));
    }
}

