/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.redundancy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.redundancy.RedundancyTestBase;

public class RedundantConsequencesTest
extends RedundancyTestBase {
    public void testRedundantTextConsequences() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Consequence.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find redundant TextConsequences"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> data = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("ConsequenceRedundancyTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<String, Set<String>> map = this.createRedundancyMap(sessionResult.iterateObjects());
        RedundantConsequencesTest.assertTrue((boolean)TestBase.mapContains(map, "Redundant consiquence 1a", "Redundant consiquence 1b"));
        RedundantConsequencesTest.assertTrue((boolean)TestBase.mapContains(map, "Redundant consiquence 1b", "Redundant consiquence 1a"));
        RedundantConsequencesTest.assertTrue((boolean)TestBase.mapContains(map, "Redundant consiquence 2a", "Redundant consiquence 2b"));
        RedundantConsequencesTest.assertTrue((boolean)TestBase.mapContains(map, "Redundant consiquence 2b", "Redundant consiquence 2a"));
        RedundantConsequencesTest.assertTrue((boolean)TestBase.mapContains(map, "Redundant consiquence 3a", "Redundant consiquence 3b"));
        RedundantConsequencesTest.assertTrue((boolean)TestBase.mapContains(map, "Redundant consiquence 3b", "Redundant consiquence 3a"));
        if (!map.isEmpty()) {
            RedundantConsequencesTest.fail((String)"More redundancies than was expected.");
        }
    }
}

