/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.subsumption;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RulePossibility;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Redundancy;
import org.drools.verifier.report.components.RedundancyType;
import org.drools.verifier.report.components.Subsumption;
import org.drools.verifier.subsumption.SubsumptionTestBase;

public class SubsumptantPossibilitiesTest
extends SubsumptionTestBase {
    public void testPatternPossibilityRedundancy1() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Possibilities.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find subsumptant pattern possibilities"));
        ArrayList<Object> data = new ArrayList<Object>();
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        String ruleName1 = "Rule 1";
        String ruleName2 = "Rule 2";
        Pattern p1 = new Pattern();
        p1.setRuleName(ruleName1);
        Pattern p2 = new Pattern();
        p2.setRuleName(ruleName2);
        LiteralRestriction lr1 = new LiteralRestriction();
        lr1.setRuleName(ruleName1);
        lr1.setOrderNumber(0);
        LiteralRestriction lr2 = new LiteralRestriction();
        lr2.setRuleName(ruleName2);
        lr2.setOrderNumber(0);
        LiteralRestriction lr3 = new LiteralRestriction();
        lr3.setRuleName(ruleName2);
        lr3.setOrderNumber(1);
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setPatternId(p1.getId());
        pp1.setRuleName(ruleName1);
        pp1.add((Restriction)lr1);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setPatternId(p2.getId());
        pp2.setRuleName(ruleName2);
        pp2.add((Restriction)lr2);
        pp2.add((Restriction)lr3);
        Redundancy r1 = new Redundancy((Cause)lr1, (Cause)lr2);
        Redundancy r2 = new Redundancy((Cause)p1, (Cause)p2);
        data.add(p1);
        data.add(p2);
        data.add(lr1);
        data.add(lr2);
        data.add(lr3);
        data.add(pp1);
        data.add(pp2);
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantPossibilitiesTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)pp1, (Cause)pp2));
        if (!map.isEmpty()) {
            SubsumptantPossibilitiesTest.fail((String)"More redundancies than was expected.");
        }
    }

    public void testPatternPossibilityRedundancy2() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Possibilities.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find subsumptant pattern possibilities"));
        ArrayList<Object> data = new ArrayList<Object>();
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        String ruleName1 = "Rule 1";
        String ruleName2 = "Rule 2";
        Pattern p1 = new Pattern();
        p1.setRuleName(ruleName1);
        Pattern p2 = new Pattern();
        p2.setRuleName(ruleName2);
        LiteralRestriction lr1 = new LiteralRestriction();
        lr1.setRuleName(ruleName1);
        lr1.setOrderNumber(0);
        LiteralRestriction lr2 = new LiteralRestriction();
        lr2.setRuleName(ruleName2);
        lr2.setOrderNumber(0);
        LiteralRestriction lr3 = new LiteralRestriction();
        lr3.setRuleName(ruleName2);
        lr3.setOrderNumber(1);
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setPatternId(p1.getId());
        pp1.setRuleName(ruleName1);
        pp1.add((Restriction)lr1);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setPatternId(p2.getId());
        pp2.setRuleName(ruleName2);
        pp2.add((Restriction)lr2);
        pp2.add((Restriction)lr3);
        Redundancy r1 = new Redundancy((Cause)lr1, (Cause)lr3);
        Redundancy r2 = new Redundancy((Cause)p1, (Cause)p2);
        data.add(p1);
        data.add(p2);
        data.add(lr1);
        data.add(lr2);
        data.add(lr3);
        data.add(pp1);
        data.add(pp2);
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantPossibilitiesTest.assertFalse((boolean)TestBase.causeMapContains(map, (Cause)pp1, (Cause)pp2));
        if (!map.isEmpty()) {
            SubsumptantPossibilitiesTest.fail((String)"More redundancies than was expected.");
        }
    }

    public void testRulePossibilityRedundancy1() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Possibilities.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find subsumptant rule possibilities"));
        ArrayList<Object> data = new ArrayList<Object>();
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        String ruleName1 = "Rule 1";
        String ruleName2 = "Rule 2";
        VerifierRule r1 = new VerifierRule();
        r1.setRuleName(ruleName1);
        VerifierRule r2 = new VerifierRule();
        r2.setRuleName(ruleName2);
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setRuleName(ruleName1);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setRuleName(ruleName2);
        PatternPossibility pp3 = new PatternPossibility();
        pp3.setRuleName(ruleName2);
        RulePossibility rp1 = new RulePossibility();
        rp1.setRuleId(r1.getId());
        rp1.setRuleName(ruleName1);
        rp1.add(pp1);
        RulePossibility rp2 = new RulePossibility();
        rp2.setRuleId(r2.getId());
        rp2.setRuleName(ruleName2);
        rp2.add(pp2);
        rp2.add(pp3);
        Redundancy possibilityredundancy = new Redundancy(RedundancyType.STRONG, (Cause)pp1, (Cause)pp2);
        Redundancy ruleRedundancy = new Redundancy((Cause)r1, (Cause)r2);
        data.add(r1);
        data.add(r2);
        data.add(pp1);
        data.add(pp2);
        data.add(pp3);
        data.add(possibilityredundancy);
        data.add(ruleRedundancy);
        data.add(rp1);
        data.add(rp2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantPossibilitiesTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)rp1, (Cause)rp2));
        if (!map.isEmpty()) {
            SubsumptantPossibilitiesTest.fail((String)"More redundancies than was expected.");
        }
    }

    public void testRulePossibilityRedundancy2() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Possibilities.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find subsumptant rule possibilities"));
        ArrayList<Object> data = new ArrayList<Object>();
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        String ruleName1 = "Rule 1";
        String ruleName2 = "Rule 2";
        VerifierRule r1 = new VerifierRule();
        r1.setRuleName(ruleName1);
        VerifierRule r2 = new VerifierRule();
        r2.setRuleName(ruleName2);
        PatternPossibility pp1 = new PatternPossibility();
        pp1.setRuleName(ruleName1);
        PatternPossibility pp2 = new PatternPossibility();
        pp2.setRuleName(ruleName1);
        PatternPossibility pp3 = new PatternPossibility();
        pp3.setRuleName(ruleName2);
        PatternPossibility pp4 = new PatternPossibility();
        pp4.setRuleName(ruleName2);
        RulePossibility rp1 = new RulePossibility();
        rp1.setRuleId(r1.getId());
        rp1.setRuleName(ruleName1);
        rp1.add(pp1);
        rp1.add(pp2);
        RulePossibility rp2 = new RulePossibility();
        rp2.setRuleId(r2.getId());
        rp2.setRuleName(ruleName2);
        rp2.add(pp3);
        rp2.add(pp4);
        Redundancy possibilityredundancy = new Redundancy(RedundancyType.STRONG, (Cause)pp1, (Cause)pp3);
        Subsumption possibilitysubsupmtion = new Subsumption((Cause)pp2, (Cause)pp4);
        Redundancy ruleRedundancy = new Redundancy((Cause)r1, (Cause)r2);
        data.add(r1);
        data.add(r2);
        data.add(pp1);
        data.add(pp2);
        data.add(pp3);
        data.add(possibilityredundancy);
        data.add(possibilitysubsupmtion);
        data.add(ruleRedundancy);
        data.add(rp1);
        data.add(rp2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantPossibilitiesTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)rp1, (Cause)rp2));
        SubsumptantPossibilitiesTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)pp2, (Cause)pp4));
        if (!map.isEmpty()) {
            SubsumptantPossibilitiesTest.fail((String)"More redundancies than was expected.");
        }
    }
}

