/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import org.drools.base.evaluators.Operator;
import org.drools.lang.descr.AccessorDescr;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.DeclarativeInvokerDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldAccessDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionCallDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.MethodAccessDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PatternSourceDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.verifier.Solvers;
import org.drools.verifier.UnknownDescriptionException;
import org.drools.verifier.components.Consequence;
import org.drools.verifier.components.Constraint;
import org.drools.verifier.components.EnumField;
import org.drools.verifier.components.EnumRestriction;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.OperatorDescr;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.QualifiedIdentifierRestriction;
import org.drools.verifier.components.ReturnValueRestriction;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.RulePossibility;
import org.drools.verifier.components.TextConsequence;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierAccessorDescr;
import org.drools.verifier.components.VerifierAccumulateDescr;
import org.drools.verifier.components.VerifierCollectDescr;
import org.drools.verifier.components.VerifierComponent;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierEvalDescr;
import org.drools.verifier.components.VerifierFieldAccessDescr;
import org.drools.verifier.components.VerifierFromDescr;
import org.drools.verifier.components.VerifierFunctionCallDescr;
import org.drools.verifier.components.VerifierMethodAccessDescr;
import org.drools.verifier.components.VerifierPredicateDescr;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.VerifierData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageDescrFlattener {
    private Solvers solvers = new Solvers();
    private VerifierData data;
    private RulePackage currentPackage = null;
    private VerifierRule currentRule = null;
    private Pattern currentPattern = null;
    private Constraint currentConstraint = null;
    private ObjectType currentObjectType = null;
    private Field currentField = null;

    PackageDescrFlattener() {
    }

    public void addPackageDescrToData(PackageDescr packageDescr, VerifierData data) throws UnknownDescriptionException {
        this.data = data;
        this.flatten(packageDescr);
        this.formPossibilities();
    }

    private void flatten(Collection<?> descrs, VerifierComponent parent) throws UnknownDescriptionException {
        int orderNumber = 0;
        for (Object o : descrs) {
            BaseDescr descr = (BaseDescr)o;
            if (descr instanceof PackageDescr) {
                this.flatten((PackageDescr)descr);
            } else if (descr instanceof RuleDescr) {
                this.flatten((RuleDescr)descr, parent);
            } else if (descr instanceof PatternDescr) {
                this.flatten((PatternDescr)descr, parent, orderNumber);
            } else if (descr instanceof VariableRestrictionDescr) {
                this.flatten((VariableRestrictionDescr)descr, parent, orderNumber);
            } else if (descr instanceof FieldBindingDescr) {
                this.flatten((FieldBindingDescr)descr, parent, orderNumber);
            } else if (descr instanceof FieldConstraintDescr) {
                this.flatten((FieldConstraintDescr)descr, parent, orderNumber);
            } else if (descr instanceof RestrictionConnectiveDescr) {
                this.flatten((RestrictionConnectiveDescr)descr, parent, orderNumber);
            } else if (descr instanceof LiteralRestrictionDescr) {
                this.flatten((LiteralRestrictionDescr)descr, parent, orderNumber);
            } else if (descr instanceof ReturnValueRestrictionDescr) {
                this.flatten((ReturnValueRestrictionDescr)descr, parent, orderNumber);
            } else if (descr instanceof QualifiedIdentifierRestrictionDescr) {
                this.flatten((QualifiedIdentifierRestrictionDescr)descr, parent, orderNumber);
            } else if (descr instanceof FunctionCallDescr) {
                this.flatten((FunctionCallDescr)descr, parent, orderNumber);
            } else if (descr instanceof PredicateDescr) {
                this.flatten((PredicateDescr)descr, parent, orderNumber);
            } else if (descr instanceof AccessorDescr) {
                this.flatten((AccessorDescr)descr, parent, orderNumber);
            } else if (descr instanceof MethodAccessDescr) {
                this.flatten((MethodAccessDescr)descr, parent, orderNumber);
            } else if (descr instanceof FieldAccessDescr) {
                this.flatten((FieldAccessDescr)descr, parent, orderNumber);
            } else if (descr instanceof PatternSourceDescr) {
                this.flatten((PatternSourceDescr)descr, parent);
            } else if (descr instanceof ConditionalElementDescr) {
                this.flatten((ConditionalElementDescr)descr, parent, orderNumber);
            }
            ++orderNumber;
        }
    }

    private VerifierComponent flatten(PatternSourceDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        if (descr instanceof AccumulateDescr) {
            return this.flatten((AccumulateDescr)descr, parent);
        }
        if (descr instanceof CollectDescr) {
            return this.flatten((CollectDescr)descr, parent);
        }
        if (descr instanceof FromDescr) {
            return this.flatten((FromDescr)descr, parent);
        }
        throw new UnknownDescriptionException((BaseDescr)descr);
    }

    private VerifierComponent flatten(DeclarativeInvokerDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        if (descr instanceof AccessorDescr) {
            return this.flatten((DeclarativeInvokerDescr)((AccessorDescr)descr), parent);
        }
        if (descr instanceof FieldAccessDescr) {
            return this.flatten((DeclarativeInvokerDescr)((FieldAccessDescr)descr), parent);
        }
        if (descr instanceof FunctionCallDescr) {
            return this.flatten((DeclarativeInvokerDescr)((FunctionCallDescr)descr), parent);
        }
        if (descr instanceof MethodAccessDescr) {
            return this.flatten((DeclarativeInvokerDescr)((MethodAccessDescr)descr), parent);
        }
        throw new UnknownDescriptionException((BaseDescr)descr);
    }

    private void flatten(ConditionalElementDescr descr, VerifierComponent parent, int orderNumber) throws UnknownDescriptionException {
        if (descr instanceof AndDescr) {
            this.flatten((AndDescr)descr, parent, orderNumber);
        } else if (descr instanceof CollectDescr) {
            this.flatten((ConditionalElementDescr)((CollectDescr)descr), parent, orderNumber);
        } else if (descr instanceof EvalDescr) {
            this.flatten((EvalDescr)descr, parent, orderNumber);
        } else if (descr instanceof ExistsDescr) {
            this.flatten((ExistsDescr)descr, parent);
        } else if (descr instanceof ForallDescr) {
            this.flatten((ForallDescr)descr, parent);
        } else if (descr instanceof FromDescr) {
            this.flatten((FromDescr)descr, parent);
        } else if (descr instanceof NotDescr) {
            this.flatten((NotDescr)descr, parent);
        } else if (descr instanceof OrDescr) {
            this.flatten((OrDescr)descr, parent, orderNumber);
        }
    }

    private void flatten(ForallDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        this.solvers.startForall();
        this.flatten(descr.getDescrs(), parent);
        this.solvers.endForall();
    }

    private void flatten(ExistsDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        this.solvers.startExists();
        this.flatten(descr.getDescrs(), parent);
        this.solvers.endExists();
    }

    private void flatten(NotDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        this.solvers.startNot();
        this.flatten(descr.getDescrs(), parent);
        this.solvers.endNot();
    }

    private VerifierFunctionCallDescr flatten(FunctionCallDescr descr, VerifierComponent parent, int orderNumber) {
        VerifierFunctionCallDescr functionCall = new VerifierFunctionCallDescr();
        functionCall.setName(descr.getName());
        functionCall.setArguments(descr.getArguments());
        functionCall.setOrderNumber(orderNumber);
        functionCall.setParent(parent);
        return functionCall;
    }

    private VerifierPredicateDescr flatten(PredicateDescr descr, VerifierComponent parent, int orderNumber) {
        VerifierPredicateDescr predicate = new VerifierPredicateDescr();
        predicate.setRuleName(this.currentRule.getRuleName());
        predicate.setRuleId(this.currentRule.getId());
        predicate.setContent(descr.getContent().toString());
        predicate.setClassMethodName(descr.getClassMethodName());
        predicate.setOrderNumber(orderNumber);
        predicate.setParent(parent);
        this.data.add(predicate);
        return predicate;
    }

    private VerifierEvalDescr flatten(EvalDescr descr, VerifierComponent parent, int orderNumber) {
        VerifierEvalDescr eval = new VerifierEvalDescr();
        eval.setRuleId(this.currentRule.getId());
        eval.setRuleName(this.currentRule.getRuleName());
        eval.setContent(descr.getContent().toString());
        eval.setClassMethodName(descr.getClassMethodName());
        eval.setOrderNumber(orderNumber);
        eval.setParent(parent);
        this.data.add(eval);
        return eval;
    }

    private VerifierFromDescr flatten(FromDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        VerifierFromDescr from = new VerifierFromDescr();
        VerifierComponent ds = this.flatten(descr.getDataSource(), (VerifierComponent)from);
        from.setDataSourceId(ds.getId());
        from.setDataSourceType(ds.getComponentType());
        from.setParent(parent);
        return from;
    }

    private VerifierAccumulateDescr flatten(AccumulateDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        VerifierAccumulateDescr accumulate = new VerifierAccumulateDescr();
        accumulate.setInputPatternId(this.flatten(descr.getInputPattern(), (VerifierComponent)accumulate, 0));
        accumulate.setInitCode(descr.getInitCode());
        accumulate.setActionCode(descr.getActionCode());
        accumulate.setReverseCode(descr.getReverseCode());
        accumulate.setResultCode(descr.getResultCode());
        accumulate.setClassName(descr.getClassName());
        accumulate.setExternalFunction(descr.isExternalFunction());
        accumulate.setFunctionIdentifier(descr.getFunctionIdentifier());
        accumulate.setExpression(descr.getExpression());
        accumulate.setParent(parent);
        return accumulate;
    }

    private VerifierCollectDescr flatten(CollectDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        VerifierCollectDescr collect = new VerifierCollectDescr();
        collect.setClassMethodName(descr.getClassMethodName());
        collect.setInsidePatternId(this.flatten(descr.getInputPattern(), (VerifierComponent)collect, 0));
        collect.setParent(parent);
        return collect;
    }

    private VerifierAccessorDescr flatten(AccessorDescr descr, VerifierComponent parent, int orderNumber) {
        VerifierAccessorDescr accessor = new VerifierAccessorDescr();
        accessor.setOrderNumber(orderNumber);
        accessor.setParent(parent);
        return accessor;
    }

    private VerifierMethodAccessDescr flatten(MethodAccessDescr descr, VerifierComponent parent, int orderNumber) {
        VerifierMethodAccessDescr accessor = new VerifierMethodAccessDescr();
        accessor.setMethodName(descr.getMethodName());
        accessor.setArguments(descr.getArguments());
        accessor.setOrderNumber(orderNumber);
        accessor.setParent(parent);
        return accessor;
    }

    private VerifierFieldAccessDescr flatten(FieldAccessDescr descr, VerifierComponent parent, int orderNumber) {
        VerifierFieldAccessDescr accessor = new VerifierFieldAccessDescr();
        accessor.setFieldName(descr.getFieldName());
        accessor.setArgument(descr.getArgument());
        accessor.setOrderNumber(orderNumber);
        accessor.setParent(parent);
        return accessor;
    }

    private void flatten(PackageDescr descr) throws UnknownDescriptionException {
        RulePackage rulePackage = this.data.getRulePackageByName(descr.getName());
        if (rulePackage == null) {
            rulePackage = new RulePackage();
            rulePackage.setName(descr.getName());
            this.data.add(rulePackage);
        }
        this.currentPackage = rulePackage;
        this.flatten(descr.getRules(), (VerifierComponent)rulePackage);
    }

    private void flatten(RuleDescr descr, VerifierComponent parent) throws UnknownDescriptionException {
        VerifierRule rule;
        this.currentRule = rule = new VerifierRule();
        rule.setRuleName(descr.getName());
        rule.setRuleSalience(descr.getSalience());
        rule.setConsequence(this.flattenConsequence(rule, descr.getConsequence()));
        rule.setLineNumber(descr.getLine());
        rule.setPackageId(this.currentPackage.getId());
        rule.setParent(parent);
        this.data.add(rule);
        this.currentPackage.getRules().add(rule);
        this.solvers.startRuleSolver(rule);
        this.flatten(descr.getLhs(), (VerifierComponent)rule, 0);
        this.solvers.endRuleSolver();
    }

    private Consequence flattenConsequence(VerifierComponent parent, Object o) {
        TextConsequence consequence = new TextConsequence();
        String text = o.toString();
        StringBuffer buffer = new StringBuffer(text);
        int commentIndex = buffer.indexOf("//");
        while (commentIndex != -1) {
            buffer = buffer.delete(commentIndex, buffer.indexOf("\n", commentIndex));
            commentIndex = buffer.indexOf("//");
        }
        text = buffer.toString();
        text = text.replaceAll("\n", "");
        text = text.replaceAll("\r", "");
        text = text.replaceAll("\t", "");
        text = text.replaceAll(" ", "");
        consequence.setText(text);
        consequence.setRuleId(this.currentRule.getId());
        consequence.setRuleName(this.currentRule.getRuleName());
        consequence.setParent(parent);
        this.data.add(consequence);
        return consequence;
    }

    private void flatten(OrDescr descr, VerifierComponent parent, int orderNumber) throws UnknownDescriptionException {
        OperatorDescr operatorDescr = new OperatorDescr(OperatorDescr.Type.OR);
        operatorDescr.setOrderNumber(orderNumber);
        operatorDescr.setParent(parent);
        this.data.add(operatorDescr);
        this.solvers.startOperator(OperatorDescr.Type.OR);
        this.flatten(descr.getDescrs(), (VerifierComponent)operatorDescr);
        this.solvers.endOperator();
    }

    private void flatten(AndDescr descr, VerifierComponent parent, int orderNumber) throws UnknownDescriptionException {
        OperatorDescr operatorDescr = new OperatorDescr(OperatorDescr.Type.AND);
        operatorDescr.setOrderNumber(orderNumber);
        operatorDescr.setParent(parent);
        this.data.add(operatorDescr);
        this.solvers.startOperator(OperatorDescr.Type.AND);
        this.flatten(descr.getDescrs(), (VerifierComponent)operatorDescr);
        this.solvers.endOperator();
    }

    private int flatten(PatternDescr descr, VerifierComponent parent, int orderNumber) throws UnknownDescriptionException {
        ObjectType objectType;
        this.currentObjectType = objectType = this.findOrCreateNewObjectType(descr.getObjectType());
        Pattern pattern = new Pattern();
        pattern.setRuleId(this.currentRule.getId());
        pattern.setRuleName(this.currentRule.getRuleName());
        pattern.setClassId(objectType.getId());
        pattern.setName(objectType.getName());
        pattern.setPatternNot(this.solvers.getRuleSolver().isChildNot());
        pattern.setPatternExists(this.solvers.getRuleSolver().isExists());
        pattern.setPatternForall(this.solvers.getRuleSolver().isForall());
        pattern.setOrderNumber(orderNumber);
        pattern.setParent(parent);
        this.data.add(pattern);
        this.currentPattern = pattern;
        if (descr.getIdentifier() != null) {
            Variable variable = new Variable();
            variable.setRuleId(this.currentRule.getId());
            variable.setRuleName(this.currentRule.getRuleName());
            variable.setName(descr.getIdentifier());
            variable.setObjectType(VerifierComponentType.CLASS);
            variable.setObjectId(objectType.getId());
            variable.setObjectName(descr.getObjectType());
            this.data.add(variable);
        }
        if (descr.getSource() != null) {
            VerifierComponent source = this.flatten(descr.getSource(), (VerifierComponent)pattern);
            pattern.setSourceId(source.getId());
            pattern.setSourceType(source.getComponentType());
        } else {
            pattern.setSourceId(0);
            pattern.setSourceType(VerifierComponentType.NOTHING);
        }
        this.solvers.startPatternSolver(pattern);
        this.flatten(descr.getConstraint(), (VerifierComponent)pattern, 0);
        this.solvers.endPatternSolver();
        return pattern.getId();
    }

    private void flatten(FieldConstraintDescr descr, VerifierComponent parent, int orderNumber) throws UnknownDescriptionException {
        Field field = this.data.getFieldByObjectTypeAndFieldName(this.currentObjectType.getName(), descr.getFieldName());
        if (field == null) {
            field = this.createField(descr.getFieldName(), this.currentObjectType.getId(), this.currentObjectType.getName());
            this.data.add(field);
        }
        this.currentField = field;
        Constraint constraint = new Constraint();
        constraint.setRuleId(this.currentRule.getId());
        constraint.setFieldId(this.currentField.getId());
        constraint.setFieldName(this.currentField.getName());
        constraint.setPatternId(this.currentPattern.getId());
        constraint.setPatternIsNot(this.currentPattern.isPatternNot());
        constraint.setFieldId(field.getId());
        constraint.setOrderNumber(orderNumber);
        constraint.setParent(parent);
        this.data.add(constraint);
        this.currentConstraint = constraint;
        this.flatten(descr.getRestriction(), (VerifierComponent)constraint, 0);
    }

    private void flatten(RestrictionConnectiveDescr descr, VerifierComponent parent, int orderNumber) throws UnknownDescriptionException {
        if (descr.getConnective() == RestrictionConnectiveDescr.AND) {
            this.solvers.startOperator(OperatorDescr.Type.AND);
            this.flatten(descr.getRestrictions(), parent);
            this.solvers.endOperator();
        } else if (descr.getConnective() == RestrictionConnectiveDescr.OR) {
            this.solvers.startOperator(OperatorDescr.Type.OR);
            this.flatten(descr.getRestrictions(), parent);
            this.solvers.endOperator();
        } else {
            throw new UnknownDescriptionException((BaseDescr)descr);
        }
    }

    private void flatten(FieldBindingDescr descr, VerifierComponent parent, int orderNumber) {
        Variable variable = new Variable();
        variable.setRuleId(this.currentRule.getId());
        variable.setRuleName(this.currentRule.getRuleName());
        variable.setName(descr.getIdentifier());
        variable.setOrderNumber(orderNumber);
        variable.setParent(parent);
        variable.setObjectType(VerifierComponentType.FIELD);
        this.data.add(variable);
    }

    private void flatten(VariableRestrictionDescr descr, VerifierComponent parent, int orderNumber) {
        Variable variable = this.data.getVariableByRuleAndVariableName(this.currentRule.getRuleName(), descr.getIdentifier());
        VariableRestriction restriction = new VariableRestriction();
        restriction.setRuleId(this.currentRule.getId());
        restriction.setRuleName(this.currentRule.getRuleName());
        restriction.setPatternId(this.currentPattern.getId());
        restriction.setPatternIsNot(this.currentPattern.isPatternNot());
        restriction.setConstraintId(this.currentConstraint.getId());
        restriction.setFieldId(this.currentConstraint.getFieldId());
        restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
        restriction.setVariable(variable);
        restriction.setOrderNumber(orderNumber);
        restriction.setParent(parent);
        this.currentField.setFieldType(Field.FieldType.VARIABLE);
        this.data.add(restriction);
        this.solvers.addRestriction(restriction);
    }

    private void flatten(ReturnValueRestrictionDescr descr, VerifierComponent parent, int orderNumber) {
        ReturnValueRestriction restriction = new ReturnValueRestriction();
        restriction.setRuleId(this.currentRule.getId());
        restriction.setRuleName(this.currentRule.getRuleName());
        restriction.setPatternId(this.currentPattern.getId());
        restriction.setPatternIsNot(this.currentPattern.isPatternNot());
        restriction.setConstraintId(this.currentConstraint.getId());
        restriction.setFieldId(this.currentConstraint.getFieldId());
        restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
        restriction.setClassMethodName(descr.getClassMethodName());
        restriction.setContent(descr.getContent());
        restriction.setDeclarations(descr.getDeclarations());
        restriction.setOrderNumber(orderNumber);
        restriction.setParent(parent);
        this.data.add(restriction);
        this.solvers.addRestriction(restriction);
    }

    private void flatten(LiteralRestrictionDescr descr, VerifierComponent parent, int orderNumber) {
        LiteralRestriction restriction = new LiteralRestriction();
        restriction.setRuleId(this.currentRule.getId());
        restriction.setRuleName(this.currentRule.getRuleName());
        restriction.setRuleId(this.currentRule.getId());
        restriction.setPatternId(this.currentPattern.getId());
        restriction.setPatternIsNot(this.currentPattern.isPatternNot());
        restriction.setConstraintId(this.currentConstraint.getId());
        restriction.setFieldId(this.currentConstraint.getFieldId());
        restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
        restriction.setValue(descr.getText());
        restriction.setOrderNumber(orderNumber);
        restriction.setParent(parent);
        this.currentField.setFieldType(restriction.getValueType());
        this.data.add(restriction);
        this.solvers.addRestriction(restriction);
    }

    private void flatten(QualifiedIdentifierRestrictionDescr descr, VerifierComponent parent, int orderNumber) {
        String text = descr.getText();
        String base = text.substring(0, text.indexOf("."));
        String fieldName = text.substring(text.indexOf("."));
        Variable variable = this.data.getVariableByRuleAndVariableName(this.currentRule.getRuleName(), base);
        if (variable != null) {
            QualifiedIdentifierRestriction restriction = new QualifiedIdentifierRestriction();
            restriction.setRuleId(this.currentRule.getId());
            restriction.setPatternId(this.currentPattern.getId());
            restriction.setPatternIsNot(this.currentPattern.isPatternNot());
            restriction.setConstraintId(this.currentConstraint.getId());
            restriction.setFieldId(this.currentConstraint.getFieldId());
            restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
            restriction.setVariableId(variable.getId());
            restriction.setVariableName(base);
            restriction.setVariablePath(fieldName);
            restriction.setOrderNumber(orderNumber);
            restriction.setParent(parent);
            this.currentField.setFieldType(Field.FieldType.VARIABLE);
            variable.setObjectType(VerifierComponentType.FIELD);
            this.data.add(restriction);
            this.solvers.addRestriction(restriction);
        } else {
            EnumField enumField = (EnumField)this.data.getFieldByObjectTypeAndFieldName(base, fieldName);
            if (enumField == null) {
                ObjectType objectType = this.findOrCreateNewObjectType(base);
                enumField = new EnumField();
                enumField.setObjectTypeId(objectType.getId());
                enumField.setClassName(objectType.getName());
                enumField.setName(fieldName);
                objectType.getFields().add(enumField);
                this.data.add(enumField);
            }
            EnumRestriction restriction = new EnumRestriction();
            restriction.setRuleId(this.currentRule.getId());
            restriction.setPatternId(this.currentPattern.getId());
            restriction.setPatternIsNot(this.currentPattern.isPatternNot());
            restriction.setConstraintId(this.currentConstraint.getId());
            restriction.setFieldId(this.currentConstraint.getFieldId());
            restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
            restriction.setEnumBaseId(enumField.getId());
            restriction.setEnumBase(base);
            restriction.setEnumName(fieldName);
            restriction.setOrderNumber(orderNumber);
            restriction.setParent(parent);
            this.currentField.setFieldType(Field.FieldType.ENUM);
            this.data.add(restriction);
            this.solvers.addRestriction(restriction);
        }
    }

    private ObjectType findOrCreateNewObjectType(String name) {
        ObjectType objectType = this.data.getObjectTypeByName(name);
        if (objectType == null) {
            objectType = new ObjectType();
            objectType.setName(name);
            this.data.add(objectType);
        }
        return objectType;
    }

    private Field createField(String fieldName, int classId, String className) {
        Field field = new Field();
        field.setObjectTypeId(classId);
        field.setClassName(className);
        field.setName(fieldName);
        this.currentObjectType.getFields().add(field);
        return field;
    }

    private void formPossibilities() {
        for (PatternPossibility patternPossibility : this.solvers.getPatternPossibilities()) {
            this.data.add(patternPossibility);
        }
        for (RulePossibility rulePossibility : this.solvers.getRulePossibilities()) {
            this.data.add(rulePossibility);
        }
    }
}

