/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.drools.verifier.components.Consequence;
import org.drools.verifier.components.Constraint;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.FieldObjectTypeLink;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.OperatorDescr;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.RulePossibility;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VerifierEvalDescr;
import org.drools.verifier.components.VerifierPredicateDescr;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.DataTree;
import org.drools.verifier.dao.VerifierData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VerifierDataMaps
implements VerifierData {
    private Map<Integer, RulePackage> packagesById = new TreeMap<Integer, RulePackage>();
    private Map<String, RulePackage> packagesByName = new TreeMap<String, RulePackage>();
    private Map<Integer, ObjectType> objectTypesById = new TreeMap<Integer, ObjectType>();
    private Map<String, ObjectType> objectTypesByName = new TreeMap<String, ObjectType>();
    private Map<String, Field> fieldsByObjectTypeAndFieldName = new TreeMap<String, Field>();
    private Map<Integer, Field> fieldsById = new TreeMap<Integer, Field>();
    private DataTree<Integer, Field> fieldsByObjectTypeId = new DataTree();
    private Map<String, FieldObjectTypeLink> fieldObjectTypeLinkByIds = new TreeMap<String, FieldObjectTypeLink>();
    private Map<Integer, VerifierRule> rulesById = new TreeMap<Integer, VerifierRule>();
    private Map<Integer, Pattern> patternsById = new TreeMap<Integer, Pattern>();
    private DataTree<Integer, Pattern> patternsByObjectTypeId = new DataTree();
    private DataTree<String, Pattern> patternsByRuleName = new DataTree();
    private Map<Integer, Constraint> constraintsById = new TreeMap<Integer, Constraint>();
    private Map<Integer, Restriction> restrictionsById = new TreeMap<Integer, Restriction>();
    private DataTree<Integer, Restriction> restrictionsByFieldId = new DataTree();
    private Map<Integer, OperatorDescr> operatorsById = new TreeMap<Integer, OperatorDescr>();
    private Map<Integer, VerifierEvalDescr> evalsById = new TreeMap<Integer, VerifierEvalDescr>();
    private Map<Integer, VerifierPredicateDescr> predicatesById = new TreeMap<Integer, VerifierPredicateDescr>();
    private Map<Integer, Consequence> consiquencesById = new TreeMap<Integer, Consequence>();
    private Map<String, Variable> variablesByRuleAndVariableName = new TreeMap<String, Variable>();
    private Map<Integer, PatternPossibility> patternPossibilitiesById = new TreeMap<Integer, PatternPossibility>();
    private Map<Integer, RulePossibility> rulePossibilitiesById = new TreeMap<Integer, RulePossibility>();

    VerifierDataMaps() {
    }

    @Override
    public void add(ObjectType objectType) {
        this.objectTypesById.put(objectType.getId(), objectType);
        this.objectTypesByName.put(objectType.getName(), objectType);
    }

    @Override
    public void add(Field field) {
        ObjectType objectType = this.objectTypesById.get(field.getObjectTypeId());
        this.fieldsByObjectTypeAndFieldName.put(objectType.getName() + "." + field.getName(), field);
        this.fieldsById.put(field.getId(), field);
        this.fieldsByObjectTypeId.put(field.getObjectTypeId(), field);
    }

    @Override
    public void add(Variable variable) {
        this.variablesByRuleAndVariableName.put(variable.getRuleName() + "." + variable.getName(), variable);
    }

    @Override
    public void add(VerifierRule rule) {
        this.rulesById.put(rule.getId(), rule);
    }

    @Override
    public void add(Pattern pattern) {
        this.patternsById.put(pattern.getId(), pattern);
        this.patternsByObjectTypeId.put(pattern.getObjectTypeId(), pattern);
        this.patternsByRuleName.put(pattern.getRuleName(), pattern);
    }

    @Override
    public void add(Constraint constraint) {
        this.constraintsById.put(constraint.getId(), constraint);
    }

    @Override
    public void add(Restriction restriction) {
        this.restrictionsById.put(restriction.getId(), restriction);
        this.restrictionsByFieldId.put(restriction.getFieldId(), restriction);
    }

    @Override
    public void add(FieldObjectTypeLink link) {
        this.fieldObjectTypeLinkByIds.put(link.getFieldId() + "." + link.getObjectTypeId(), link);
    }

    @Override
    public ObjectType getObjectTypeByName(String name) {
        return this.objectTypesByName.get(name);
    }

    @Override
    public Field getFieldByObjectTypeAndFieldName(String objectTypeName, String fieldName) {
        return this.fieldsByObjectTypeAndFieldName.get(objectTypeName + "." + fieldName);
    }

    @Override
    public Variable getVariableByRuleAndVariableName(String ruleName, String variableName) {
        return this.variablesByRuleAndVariableName.get(ruleName + "." + variableName);
    }

    @Override
    public FieldObjectTypeLink getFieldObjectTypeLink(int id, int id2) {
        return this.fieldObjectTypeLinkByIds.get(id + "." + id2);
    }

    @Override
    public Collection<VerifierRule> getAllRules() {
        return this.rulesById.values();
    }

    @Override
    public void add(PatternPossibility possibility) {
        this.patternPossibilitiesById.put(possibility.getId(), possibility);
    }

    @Override
    public void add(RulePossibility possibility) {
        this.rulePossibilitiesById.put(possibility.getId(), possibility);
    }

    @Override
    public Collection<ObjectType> getObjectTypesByRuleName(String ruleName) {
        HashSet<ObjectType> set = new HashSet<ObjectType>();
        for (Pattern pattern : this.patternsByRuleName.getBranch(ruleName)) {
            ObjectType objectType = this.getObjectTypeById(pattern.getObjectTypeId());
            set.add(objectType);
        }
        return set;
    }

    @Override
    public ObjectType getObjectTypeById(int id) {
        return this.objectTypesById.get(id);
    }

    @Override
    public Collection<? extends Object> getAll() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.addAll(this.packagesById.values());
        objects.addAll(this.rulesById.values());
        objects.addAll(this.patternsById.values());
        objects.addAll(this.constraintsById.values());
        objects.addAll(this.restrictionsById.values());
        objects.addAll(this.operatorsById.values());
        objects.addAll(this.evalsById.values());
        objects.addAll(this.predicatesById.values());
        objects.addAll(this.consiquencesById.values());
        objects.addAll(this.patternPossibilitiesById.values());
        objects.addAll(this.rulePossibilitiesById.values());
        objects.addAll(this.objectTypesByName.values());
        objects.addAll(this.fieldsByObjectTypeAndFieldName.values());
        objects.addAll(this.variablesByRuleAndVariableName.values());
        return objects;
    }

    @Override
    public Collection<ObjectType> getAllObjectTypes() {
        return this.objectTypesById.values();
    }

    @Override
    public Collection<Field> getFieldsByObjectTypeId(int id) {
        return this.fieldsByObjectTypeId.getBranch(id);
    }

    @Override
    public Collection<VerifierRule> getRulesByObjectTypeId(int id) {
        HashSet<VerifierRule> rules = new HashSet<VerifierRule>();
        for (Pattern pattern : this.patternsByObjectTypeId.getBranch(id)) {
            rules.add(this.rulesById.get(pattern.getRuleId()));
        }
        return rules;
    }

    @Override
    public Collection<Field> getAllFields() {
        return this.fieldsById.values();
    }

    @Override
    public Collection<VerifierRule> getRulesByFieldId(int id) {
        HashSet<VerifierRule> rules = new HashSet<VerifierRule>();
        for (Restriction restriction : this.restrictionsByFieldId.getBranch(id)) {
            rules.add(this.rulesById.get(restriction.getRuleId()));
        }
        return rules;
    }

    @Override
    public Collection<RulePackage> getAllRulePackages() {
        return this.packagesById.values();
    }

    @Override
    public void add(RulePackage rulePackage) {
        this.packagesById.put(rulePackage.getId(), rulePackage);
        this.packagesByName.put(rulePackage.getName(), rulePackage);
    }

    @Override
    public RulePackage getRulePackageByName(String name) {
        return this.packagesByName.get(name);
    }

    @Override
    public Collection<Restriction> getRestrictionsByFieldId(int id) {
        return this.restrictionsByFieldId.getBranch(id);
    }

    @Override
    public void add(OperatorDescr operatorDescr) {
        this.operatorsById.put(operatorDescr.getId(), operatorDescr);
    }

    @Override
    public void add(VerifierEvalDescr eval) {
        this.evalsById.put(eval.getId(), eval);
    }

    @Override
    public void add(VerifierPredicateDescr predicate) {
        this.predicatesById.put(predicate.getId(), predicate);
    }

    @Override
    public void add(Consequence consequence) {
        this.consiquencesById.put(consequence.getId(), consequence);
    }
}

