/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report;

import com.thoughtworks.xstream.XStream;
import java.util.Collection;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.report.components.Gap;
import org.drools.verifier.report.components.MissingNumberPattern;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.drools.verifier.report.components.VerifierMessageBase;

public class ReportModeller {
    public static String writeXML(VerifierResult result) {
        XStream xstream = new XStream();
        xstream.alias("result", VerifierResult.class);
        xstream.alias("message", VerifierMessage.class);
        xstream.alias("Gap", Gap.class);
        xstream.alias("MissingNumber", MissingNumberPattern.class);
        xstream.alias("Field", Field.class);
        xstream.alias("LiteralRestriction", LiteralRestriction.class);
        return "<?xml version=\"1.0\"?>\n" + xstream.toXML((Object)result);
    }

    public static String writePlainText(VerifierResult result) {
        StringBuffer str = new StringBuffer();
        for (Severity severity : Severity.values()) {
            Collection<VerifierMessageBase> messages = result.getBySeverity(severity);
            str.append("************* ");
            str.append(severity.getTuple());
            str.append(" ");
            str.append(messages.size());
            str.append(" ******************\n");
            for (VerifierMessageBase message : messages) {
                str.append(message);
                str.append("\n");
            }
            str.append("\n");
        }
        return str.toString();
    }
}

