/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.components;

import java.util.Collection;
import java.util.Collections;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.MessageType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierMessage
extends VerifierMessageBase {
    private static final long serialVersionUID = 9190003495068712452L;
    protected final Collection<Cause> causes;

    public VerifierMessage(Severity severity, MessageType messageType, Cause faulty, String message, Collection<Cause> causes) {
        super(severity, messageType, faulty, message);
        this.causes = causes;
    }

    public VerifierMessage(Severity severity, MessageType messageType, Cause faulty, String message) {
        super(severity, messageType, faulty, message);
        this.causes = Collections.emptyList();
    }

    public Collection<Cause> getCauses() {
        return this.causes;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer(this.severity.getSingular());
        str.append(" id = ");
        str.append(this.id);
        str.append(":\n");
        if (this.faulty != null) {
            str.append("faulty : ");
            str.append(this.faulty);
            str.append(", ");
        }
        str.append(this.message);
        str.append(" \n\tCauses are [ \n");
        for (Cause cause : this.causes) {
            str.append("\t\t");
            str.append(cause);
            str.append("\n");
        }
        str.append("\t]");
        return str.toString();
    }
}

