/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Gap;

public class RangeCheckDatesTest
extends TestBase {
    public void testFake() {
        RangeCheckDatesTest.assertTrue((boolean)true);
    }

    public void testSmallerOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("rangeChecks/Dates.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for dates, if smaller than or equal is missing"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingRangesForDates.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 4a"));
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 5a"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                RangeCheckDatesTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testGreaterOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("rangeChecks/Dates.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for dates, if greater than or equal is missing"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingRangesForDates.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 4b"));
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 5b"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                RangeCheckDatesTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testEqualAndGreaterThan() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("rangeChecks/Dates.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for dates, equal and greater than"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingRangesForDates.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 1"));
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 7b"));
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 3"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                RangeCheckDatesTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testEqualAndSmallerThan() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("rangeChecks/Dates.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for dates, equal and smaller than"));
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingRangesForDates.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 1"));
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 6b"));
        RangeCheckDatesTest.assertTrue((boolean)rulesThatHadErrors.remove("Date gap rule 2"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                RangeCheckDatesTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

