/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.drools.compiler.DrlParser;
import org.drools.lang.descr.PackageDescr;
import org.drools.verifier.Verifier;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.drools.verifier.report.components.VerifierRangeCheckMessage;

class VerifierTestStandalone {
    VerifierTestStandalone() {
    }

    public static final void main(String[] args) {
        try {
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add("Enums.drl");
            DrlParser parser = new DrlParser();
            Verifier a = new Verifier();
            for (String s : fileNames) {
                PackageDescr descr = parser.parse((Reader)new InputStreamReader(Verifier.class.getResourceAsStream(s)));
                a.addPackageDescr(descr);
            }
            a.fireAnalysis();
            a.writeComponentsHTML("/home/trikkola/");
            VerifierResult result = a.getResult();
            Collection msgs = result.getBySeverity(Severity.ERROR);
            for (VerifierMessageBase msg : msgs) {
                System.out.println("ERR: " + msg.getMessage());
            }
            msgs = result.getBySeverity(Severity.WARNING);
            for (VerifierMessageBase msg : msgs) {
                VerifierMessage amsg;
                System.out.println("WARN (" + msg.getClass().getSimpleName() + "): " + msg.getMessage());
                System.out.println("\t FAULT: [" + msg.getClass().getSimpleName() + "] " + msg.getFaulty());
                if (msg instanceof VerifierMessage) {
                    System.out.println("\t CAUSES (message):");
                    amsg = (VerifierMessage)msg;
                    for (Cause c : amsg.getCauses()) {
                        System.out.println("\t\t [" + c.getClass().getSimpleName() + "]" + c);
                    }
                    continue;
                }
                if (!(msg instanceof VerifierRangeCheckMessage)) continue;
                System.out.println("\t CAUSES (range):");
                amsg = (VerifierRangeCheckMessage)msg;
                for (Cause c : amsg.getCauses()) {
                    System.out.println("\t\t" + c);
                }
            }
            msgs = result.getBySeverity(Severity.NOTE);
            for (VerifierMessageBase msg : msgs) {
                System.out.println("NOTE: " + msg.getMessage());
                System.out.println("\t" + msg.getFaulty());
            }
            Collection classes = result.getVerifierData().getAllObjectTypes();
            for (ObjectType c : classes) {
                Collection cr = result.getVerifierData().getRulesByObjectTypeId(c.getId());
                System.err.println("Class rules:" + cr);
                Set flds = c.getFields();
                for (Field f : flds) {
                    cr = result.getVerifierData().getRulesByFieldId(f.getId());
                    System.err.println("Field rules: " + cr);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void writeToFile(String fileName, String text) {
        try {
            FileWriter fstream = new FileWriter(fileName);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(text);
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

