/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.equivalence;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.redundancy.RedundancyTestBase;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Redundancy;

public class EquivalentRulesTest
extends RedundancyTestBase {
    public void testRuleRedundancy() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Rules.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find equivalent Rules"));
        ArrayList<Object> data = new ArrayList<Object>();
        String ruleName1 = "Rule 1";
        String ruleName2 = "Rule 2";
        VerifierRule rule1 = new VerifierRule();
        rule1.setRuleName(ruleName1);
        VerifierRule rule2 = new VerifierRule();
        rule2.setRuleName(ruleName2);
        Redundancy r1 = new Redundancy((Cause)rule1, (Cause)rule2);
        data.add(rule1);
        data.add(rule2);
        data.add(r1);
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<String, Set<String>> map = this.createRedundancyMap(sessionResult.iterateObjects());
        EquivalentRulesTest.assertTrue((boolean)TestBase.mapContains(map, ruleName1, ruleName2));
        EquivalentRulesTest.assertTrue((boolean)TestBase.mapContains(map, ruleName2, ruleName1));
        if (!map.isEmpty()) {
            EquivalentRulesTest.fail((String)"More equivalences than was expected.");
        }
    }
}

