/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Gap;

public class RangeCheckDoublesTest
extends TestBase {
    public void testSmallerOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, if smaller than or equal is missing"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 4a"));
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 5a"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                RangeCheckDoublesTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testGreaterOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, if greater than or equal is missing"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 4b"));
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 5b"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                RangeCheckDoublesTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testEqualAndGreaterThan() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, equal and greater than"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 1"));
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 7b"));
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 3"));
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 9b"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                RangeCheckDoublesTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testEqualAndSmallerThan() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, equal and smaller than"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        StatelessSessionResult sessionResult = session.executeWithResults(testData);
        Iterator iter = sessionResult.iterateObjects();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 1"));
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 6b"));
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 2"));
        RangeCheckDoublesTest.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 9a"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                RangeCheckDoublesTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

