/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.jar.JarInputStream;
import junit.framework.TestCase;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.impl.ClassPathResource;
import org.drools.io.impl.ReaderResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

public class VerifierTest
extends TestCase {
    public void testVerifier() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifierTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        VerifierTest.assertFalse((boolean)verifier.hasErrors());
        VerifierTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        VerifierTest.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        VerifierTest.assertNotNull((Object)result);
        VerifierTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        VerifierTest.assertEquals((int)6, (int)result.getBySeverity(Severity.WARNING).size());
        VerifierTest.assertEquals((int)1, (int)result.getBySeverity(Severity.NOTE).size());
    }

    public void testVerifierInvalidDRLs() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifierTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        String drl = "This will not work";
        verifier.addResourcesToVerify((Resource)new ReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        VerifierTest.assertTrue((boolean)verifier.hasErrors());
        VerifierTest.assertEquals((int)4, (int)verifier.getErrors().size());
    }

    public void testVerifierNullPackageDescr() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifierTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        String drl = "#This will not work";
        verifier.addResourcesToVerify((Resource)new ReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        VerifierTest.assertTrue((boolean)verifier.hasErrors());
        VerifierTest.assertEquals((int)1, (int)verifier.getErrors().size());
    }

    public void testFactTypesFromJar() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifierTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        try {
            JarInputStream jar = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("model.jar"));
            verifier.addObjectModel(jar);
        }
        catch (IOException e) {
            VerifierTest.fail((String)e.getMessage());
        }
        verifier.addResourcesToVerify((Resource)new ClassPathResource("imports.drl", Verifier.class), ResourceType.DRL);
        VerifierTest.assertFalse((boolean)verifier.hasErrors());
        VerifierTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        VerifierTest.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Collection objectTypes = result.getVerifierData().getAll(VerifierComponentType.OBJECT_TYPE);
        VerifierTest.assertNotNull((Object)objectTypes);
        VerifierTest.assertEquals((int)3, (int)objectTypes.size());
        Collection fields = result.getVerifierData().getAll(VerifierComponentType.FIELD);
        VerifierTest.assertNotNull((Object)fields);
        VerifierTest.assertEquals((int)10, (int)fields.size());
    }

    public void testFactTypesFromJarAndDeclarations() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifierTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        try {
            JarInputStream jar = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("model.jar"));
            verifier.addObjectModel(jar);
        }
        catch (IOException e) {
            VerifierTest.fail((String)e.getMessage());
        }
        verifier.addResourcesToVerify((Resource)new ClassPathResource("importsAndDeclarations.drl", Verifier.class), ResourceType.DRL);
        VerifierTest.assertFalse((boolean)verifier.hasErrors());
        VerifierTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        VerifierTest.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Collection objectTypes = result.getVerifierData().getAll(VerifierComponentType.OBJECT_TYPE);
        for (ObjectType objectType : objectTypes) {
            if (!objectType.getName().equals("VoiceCall")) continue;
            VerifierTest.assertEquals((int)4, (int)objectType.getMetadata().keySet().size());
        }
        VerifierTest.assertNotNull((Object)objectTypes);
        VerifierTest.assertEquals((int)4, (int)objectTypes.size());
        Collection fields = result.getVerifierData().getAll(VerifierComponentType.FIELD);
        VerifierTest.assertNotNull((Object)fields);
        VerifierTest.assertEquals((int)11, (int)fields.size());
    }

    public void testCustomRule() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        VerifierTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifierTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        vConfiguration.getVerifyingResources().put(new ClassPathResource("FindPatterns.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        VerifierTest.assertFalse((boolean)verifier.hasErrors());
        VerifierTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        if (!works) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            VerifierTest.fail((String)"Could not run verifier");
        }
        VerifierTest.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        VerifierTest.assertNotNull((Object)result);
        VerifierTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        VerifierTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        VerifierTest.assertEquals((int)6, (int)result.getBySeverity(Severity.NOTE).size());
        for (VerifierMessageBase m : result.getBySeverity(Severity.NOTE)) {
            VerifierTest.assertEquals((String)"This pattern was found.", (String)m.getMessage());
        }
    }
}

