/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.impl.ClassPathResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;

public class VerifyingScopeTest
extends TestCase {
    public void testSingleRule() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        VerifyingScopeTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifyingScopeTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        VerifyingScopeTest.assertFalse((boolean)verifier.hasErrors());
        VerifyingScopeTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(true, "single-rule"));
        if (!works) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            VerifyingScopeTest.fail((String)"Error when building in verifier");
        }
        VerifierReport result = verifier.getResult();
        VerifyingScopeTest.assertNotNull((Object)result);
        VerifyingScopeTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        VerifyingScopeTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        VerifyingScopeTest.assertEquals((int)6, (int)result.getBySeverity(Severity.NOTE).size());
    }

    public void testNothing() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        VerifyingScopeTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifyingScopeTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        VerifyingScopeTest.assertFalse((boolean)verifier.hasErrors());
        VerifyingScopeTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(true, (Collection)Collections.EMPTY_LIST));
        VerifyingScopeTest.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        VerifyingScopeTest.assertNotNull((Object)result);
        VerifyingScopeTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        VerifyingScopeTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        VerifyingScopeTest.assertEquals((int)2, (int)result.getBySeverity(Severity.NOTE).size());
    }

    public void testDecisionTable() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        VerifyingScopeTest.assertFalse((boolean)vBuilder.hasErrors());
        VerifyingScopeTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        VerifyingScopeTest.assertFalse((boolean)verifier.hasErrors());
        VerifyingScopeTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(false, "decision-table"));
        VerifyingScopeTest.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        VerifyingScopeTest.assertNotNull((Object)result);
        VerifyingScopeTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        VerifyingScopeTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        VerifyingScopeTest.assertEquals((int)2, (int)result.getBySeverity(Severity.NOTE).size());
    }
}

