/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.alwaysFalse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Incompatibility;
import org.drools.verifier.report.components.MessageType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.drools.verifier.report.components.VerifierMessageBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlwaysFalseTest
extends TestBase {
    public void testPatterns() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Pattern that is always false"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"");
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"");
        Incompatibility i1 = new Incompatibility((Cause)r1, (Cause)r2);
        SubPattern pp1 = new SubPattern(pattern1, 0);
        pp1.add((PatternComponent)r1);
        pp1.add((PatternComponent)r2);
        VariableRestriction r3 = new VariableRestriction(pattern1);
        VariableRestriction r4 = new VariableRestriction(pattern1);
        Incompatibility i2 = new Incompatibility((Cause)r1, (Cause)r2);
        SubPattern pp2 = new SubPattern(pattern1, 1);
        pp2.add((PatternComponent)r1);
        pp2.add((PatternComponent)r2);
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        LiteralRestriction r5 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"");
        LiteralRestriction r6 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"");
        SubPattern pp3 = new SubPattern(pattern2, 0);
        pp3.add((PatternComponent)r5);
        pp3.add((PatternComponent)r6);
        VariableRestriction r7 = new VariableRestriction(pattern2);
        VariableRestriction r8 = new VariableRestriction(pattern2);
        Incompatibility i4 = new Incompatibility((Cause)r7, (Cause)r8);
        SubPattern pp4 = new SubPattern(pattern2, 1);
        pp4.add((PatternComponent)r7);
        pp4.add((PatternComponent)r8);
        data.add(VerifierComponentMockFactory.createRule1());
        data.add(pattern1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(i1);
        data.add(i2);
        data.add(pp1);
        data.add(pp2);
        data.add(pattern2);
        data.add(r5);
        data.add(r6);
        data.add(r7);
        data.add(r8);
        data.add(i4);
        data.add(pp3);
        data.add(pp4);
        session.executeWithResults(data);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        boolean works = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            if (message.getFaulty().equals(pattern1)) {
                works = true;
                continue;
            }
            AlwaysFalseTest.fail((String)"There can be only one. (And this is not the one)");
        }
        AlwaysFalseTest.assertEquals((int)1, (int)result.getBySeverity(Severity.ERROR).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.NOTE).size());
        AlwaysFalseTest.assertTrue((boolean)works);
    }

    public void testSinglePatternNoRestrictions() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Pattern that is always false"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = VerifierComponentMockFactory.createRule1();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        data.add(rule1);
        data.add(pattern1);
        session.executeWithResults(data);
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.NOTE).size());
    }

    public void testRules() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Rules.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Rule that is always false"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = VerifierComponentMockFactory.createRule1();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        SubPattern pp1 = new SubPattern(pattern1, 0);
        SubPattern pp2 = new SubPattern(pattern1, 1);
        Incompatibility i1 = new Incompatibility((Cause)pp1, (Cause)pp2);
        SubRule rp1 = new SubRule(rule1, 0);
        rp1.add((RuleComponent)pp1);
        rp1.add((RuleComponent)pp2);
        SubPattern pp3 = new SubPattern(pattern1, 2);
        SubPattern pp4 = new SubPattern(pattern1, 3);
        Incompatibility i2 = new Incompatibility((Cause)pp1, (Cause)pp2);
        SubRule rp2 = new SubRule(rule1, 1);
        rp2.add((RuleComponent)pp1);
        rp2.add((RuleComponent)pp2);
        VerifierRule rule2 = VerifierComponentMockFactory.createRule2();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        SubPattern pp5 = new SubPattern(pattern2, 0);
        SubPattern pp6 = new SubPattern(pattern2, 1);
        SubRule rp3 = new SubRule(rule2, 2);
        rp3.add((RuleComponent)pp5);
        rp3.add((RuleComponent)pp6);
        SubPattern pp7 = new SubPattern(pattern2, 2);
        SubPattern pp8 = new SubPattern(pattern2, 3);
        Incompatibility i4 = new Incompatibility((Cause)pp7, (Cause)pp8);
        SubRule rp4 = new SubRule(rule2, 3);
        rp4.add((RuleComponent)pp7);
        rp4.add((RuleComponent)pp8);
        data.add(rule1);
        data.add(pp1);
        data.add(pp2);
        data.add(pp3);
        data.add(pp4);
        data.add(i1);
        data.add(i2);
        data.add(rp1);
        data.add(rp2);
        data.add(rule2);
        data.add(pp5);
        data.add(pp6);
        data.add(pp7);
        data.add(pp8);
        data.add(i4);
        data.add(rp3);
        data.add(rp4);
        session.executeWithResults(data);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        boolean works = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            if (message.getFaulty().equals(rule1)) {
                works = true;
                continue;
            }
            AlwaysFalseTest.fail((String)"There can be only one. (And this is not the one)");
        }
        AlwaysFalseTest.assertEquals((int)1, (int)result.getBySeverity(Severity.ERROR).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.WARNING).size());
        AlwaysFalseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.NOTE).size());
        AlwaysFalseTest.assertTrue((boolean)works);
    }

    public void testAlwaysFalse() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"AlwaysFalseTest.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        AlwaysFalseTest.assertFalse((boolean)verifier.hasErrors());
        boolean noProblems = verifier.fireAnalysis();
        AlwaysFalseTest.assertTrue((boolean)noProblems);
        Collection notes = verifier.getResult().getBySeverity(Severity.ERROR);
        AlwaysFalseTest.assertEquals((int)1, (int)this.containsMessageType(notes, MessageType.ALWAYS_FALSE));
        verifier.dispose();
    }

    private int containsMessageType(Collection<VerifierMessageBase> notes, MessageType type) {
        int amount = 0;
        for (VerifierMessageBase note : notes) {
            VerifierMessage message;
            if (!(note instanceof VerifierMessage) || (message = (VerifierMessage)note).getMessageType() != type) continue;
            ++amount;
        }
        return amount;
    }
}

