/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incoherence;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;

public class IncoherentPatternsTest
extends TestBase {
    public void testIncoherentPatternsInSubRule() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 1"));
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 2"));
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 7"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentPatternsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentPatternsInSubRuleVariables() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, variables"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 3"));
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 4"));
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 5"));
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 6"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentPatternsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentPatternsInSubRuleRangesLess() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with lesser value"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 8"));
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 12"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentPatternsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentPatternsInSubRuleRangesGreater() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with greater value"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 9"));
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 14"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentPatternsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentPatternsInSubRuleRangesEqualOrUnequal() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal or unequal value"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 10"));
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 15"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentPatternsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentPatternsInSubRuleRangesEqualOrUnequalVariables() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal or unequal variables"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 11"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentPatternsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentPatternsInSubRuleRangesEqualValue() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal value"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 16"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentPatternsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentPatternsInSubRuleRangesEqualVariable() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal variable"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(rule.getName());
        }
        IncoherentPatternsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent patterns 13"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentPatternsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

