/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incompatibility;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.base.evaluators.Operator;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.incompatibility.IncompatibilityBase;
import org.drools.verifier.report.components.Cause;

public class IncompatibilityRestrictionsTest
extends IncompatibilityBase {
    public void testLiteralRestrictionsIncompatibilityLessOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incompatible LiteralRestrictions with ranges in pattern possibility, impossible equality less or equal"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"10");
        r1.setOperator(Operator.EQUAL);
        r1.setFieldPath("0");
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"1");
        r2.setOperator(Operator.LESS);
        r2.setFieldPath("0");
        r2.setOrderNumber(2);
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"1");
        r3.setOperator(Operator.GREATER_OR_EQUAL);
        r3.setFieldPath("1");
        r3.setOrderNumber(0);
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"10");
        r4.setOperator(Operator.EQUAL);
        r4.setFieldPath("1");
        r4.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        IncompatibilityRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            IncompatibilityRestrictionsTest.fail((String)"More incompatibilities than was expected.");
        }
    }

    public void testLiteralRestrictionsIncompatibilityGreater() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incompatible LiteralRestrictions with ranges in pattern possibility, impossible equality greater"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"10");
        r1.setOperator(Operator.GREATER);
        r1.setFieldPath("0");
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"1");
        r2.setOperator(Operator.EQUAL);
        r2.setFieldPath("0");
        r2.setOrderNumber(1);
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"1");
        r3.setOperator(Operator.GREATER_OR_EQUAL);
        r3.setFieldPath("1");
        r3.setOrderNumber(0);
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"10");
        r4.setOperator(Operator.EQUAL);
        r4.setFieldPath("1");
        r4.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        IncompatibilityRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            IncompatibilityRestrictionsTest.fail((String)"More incompatibilities than was expected.");
        }
    }

    public void testLiteralRestrictionsIncompatibilityImpossibleRange() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incompatible LiteralRestrictions with ranges in pattern possibility, impossible range"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"10");
        r1.setOperator(Operator.GREATER);
        r1.setFieldPath("0");
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"10");
        r2.setOperator(Operator.LESS);
        r2.setFieldPath("0");
        r2.setOrderNumber(1);
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"1");
        r3.setOperator(Operator.GREATER_OR_EQUAL);
        r3.setFieldPath("1");
        r3.setOrderNumber(0);
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"");
        r4.setOperator(Operator.EQUAL);
        r4.setFieldPath("1");
        r4.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        IncompatibilityRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            IncompatibilityRestrictionsTest.fail((String)"More incompatibilities than was expected.");
        }
    }

    public void testVariableRestrictionsIncompatibilityImpossibleRange() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent VariableRestrictions in pattern possibility, impossible range"));
        ArrayList<VariableRestriction> data = new ArrayList<VariableRestriction>();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        ObjectType objectType = new ObjectType();
        objectType.setFullName("org.test.Person");
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        Variable variable1 = new Variable(rule);
        variable1.setObjectTypePath("0");
        variable1.setObjectTypeType(VerifierComponentType.FIELD.getType());
        variable1.setOrderNumber(11);
        VariableRestriction r1 = new VariableRestriction(pattern1);
        r1.setOperator(Operator.GREATER);
        r1.setFieldPath("0");
        r1.setVariable(variable1);
        r1.setOrderNumber(0);
        VariableRestriction r2 = new VariableRestriction(pattern1);
        r2.setOperator(Operator.LESS);
        r2.setFieldPath("0");
        r2.setVariable(variable1);
        r2.setOrderNumber(1);
        Variable variable2 = new Variable(rule);
        variable2.setObjectTypePath("1");
        variable2.setObjectTypeType(VerifierComponentType.FIELD.getType());
        variable2.setOrderNumber(10);
        VariableRestriction r3 = new VariableRestriction(pattern2);
        r3.setOperator(Operator.GREATER_OR_EQUAL);
        r3.setFieldPath("1");
        r3.setVariable(variable2);
        r3.setOrderNumber(0);
        VariableRestriction r4 = new VariableRestriction(pattern2);
        r4.setOperator(Operator.EQUAL);
        r4.setFieldPath("1");
        r4.setVariable(variable2);
        r4.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        IncompatibilityRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            IncompatibilityRestrictionsTest.fail((String)"More incompatibilities than was expected.");
        }
    }
}

