/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.redundancy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Redundancy;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

public class NotesTest
extends TestBase {
    public void testRedundantRestrictionsInPatternPossibilities() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Notes.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find redundant restrictions from pattern possibilities"));
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        ArrayList<Object> objects = new ArrayList<Object>();
        LiteralRestriction left = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction right = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        Redundancy redundancy = new Redundancy((VerifierComponent)left, (VerifierComponent)right);
        SubPattern possibility = new SubPattern(pattern, 0);
        possibility.add((PatternComponent)left);
        possibility.add((PatternComponent)right);
        objects.add(left);
        objects.add(right);
        objects.add(redundancy);
        objects.add(possibility);
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        session.setGlobal("result", (Object)result);
        session.executeWithResults(objects);
        Collection notes = result.getBySeverity(Severity.NOTE);
        NotesTest.assertEquals((int)1, (int)notes.size());
        VerifierMessageBase note = (VerifierMessageBase)notes.iterator().next();
        Iterator causes = note.getCauses().iterator();
        NotesTest.assertEquals((Object)left, causes.next());
        NotesTest.assertEquals((Object)right, causes.next());
    }

    public void testRedundantPatternPossibilitiesInRulePossibilities() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Notes.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find redundant pattern possibilities from rule possibilities"));
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        ArrayList<Object> objects = new ArrayList<Object>();
        SubPattern left = new SubPattern(pattern, 0);
        SubPattern right = new SubPattern(pattern, 1);
        Redundancy redundancy = new Redundancy((VerifierComponent)left, (VerifierComponent)right);
        SubRule possibility = new SubRule(rule, 0);
        possibility.add((RuleComponent)left);
        possibility.add((RuleComponent)right);
        objects.add(left);
        objects.add(right);
        objects.add(redundancy);
        objects.add(possibility);
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        session.setGlobal("result", (Object)result);
        session.executeWithResults(objects);
        Collection notes = result.getBySeverity(Severity.NOTE);
        NotesTest.assertEquals((int)1, (int)notes.size());
        VerifierMessageBase note = (VerifierMessageBase)notes.iterator().next();
        Iterator causes = note.getCauses().iterator();
        NotesTest.assertEquals((Object)left, causes.next());
        NotesTest.assertEquals((Object)right, causes.next());
    }
}

