/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.solver.Solvers;

public class SolversTest
extends TestCase {
    public void testNotAnd() {
        RulePackage rulePackage = new RulePackage();
        rulePackage.setName("testPackage");
        VerifierRule rule = new VerifierRule(rulePackage);
        rule.setName("testRule");
        Pattern pattern = new Pattern(rule);
        LiteralRestriction r = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        Solvers solvers = new Solvers();
        solvers.startRuleSolver(rule);
        solvers.startOperator(OperatorDescrType.AND);
        solvers.startPatternSolver(pattern);
        solvers.startOperator(OperatorDescrType.AND);
        solvers.addPatternComponent((PatternComponent)r);
        solvers.addPatternComponent((PatternComponent)r2);
        solvers.endOperator();
        solvers.endPatternSolver();
        solvers.startNot();
        solvers.startPatternSolver(pattern);
        solvers.startOperator(OperatorDescrType.AND);
        solvers.addPatternComponent((PatternComponent)r3);
        solvers.addPatternComponent((PatternComponent)r4);
        solvers.endOperator();
        solvers.endPatternSolver();
        solvers.endNot();
        solvers.endOperator();
        solvers.endRuleSolver();
        List list = solvers.getRulePossibilities();
        SolversTest.assertEquals((int)1, (int)list.size());
        SolversTest.assertEquals((int)2, (int)((SubRule)list.get(0)).getItems().size());
        ArrayList<LiteralRestriction> result = new ArrayList<LiteralRestriction>();
        result.add(r);
        result.add(r2);
        ArrayList<LiteralRestriction> result2 = new ArrayList<LiteralRestriction>();
        result2.add(r3);
        result2.add(r4);
        Object[] possibilies = ((SubRule)list.get(0)).getItems().toArray();
        SubPattern p1 = (SubPattern)possibilies[0];
        SubPattern p2 = (SubPattern)possibilies[1];
        if (p1.getItems().containsAll(result)) {
            SolversTest.assertTrue((boolean)p2.getItems().containsAll(result2));
        } else if (p1.getItems().containsAll(result2)) {
            SolversTest.assertTrue((boolean)p2.getItems().containsAll(result));
        } else {
            SolversTest.fail((String)"No items found.");
        }
    }

    public void testBasicAnd() {
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction r = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        Solvers solvers = new Solvers();
        solvers.startRuleSolver(rule);
        solvers.startPatternSolver(pattern);
        solvers.startOperator(OperatorDescrType.AND);
        solvers.addPatternComponent((PatternComponent)r);
        solvers.addPatternComponent((PatternComponent)r2);
        solvers.endOperator();
        solvers.endPatternSolver();
        solvers.endRuleSolver();
        List list = solvers.getRulePossibilities();
        SolversTest.assertEquals((int)1, (int)list.size());
        SolversTest.assertEquals((int)1, (int)((SubRule)list.get(0)).getItems().size());
        ArrayList<LiteralRestriction> result = new ArrayList<LiteralRestriction>();
        result.add(r);
        result.add(r2);
        Set set = ((SubRule)list.get(0)).getItems();
        for (RuleComponent component : set) {
            SubPattern possibility = (SubPattern)component;
            SolversTest.assertTrue((boolean)possibility.getItems().containsAll(result));
        }
    }
}

