/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.data;

import java.util.Collection;
import junit.framework.TestCase;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.Constraint;
import org.drools.verifier.components.EnumField;
import org.drools.verifier.components.EnumRestriction;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.InlineEvalDescr;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternEval;
import org.drools.verifier.components.PatternOperatorDescr;
import org.drools.verifier.components.QualifiedIdentifierRestriction;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.ReturnValueFieldDescr;
import org.drools.verifier.components.ReturnValueRestriction;
import org.drools.verifier.components.RuleEval;
import org.drools.verifier.components.RuleOperatorDescr;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.TextConsequence;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierAccessorDescr;
import org.drools.verifier.components.VerifierAccumulateDescr;
import org.drools.verifier.components.VerifierCollectDescr;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierFieldAccessDescr;
import org.drools.verifier.components.VerifierFromDescr;
import org.drools.verifier.components.VerifierMethodAccessDescr;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;

public class VerifierDataMapsTest
extends TestCase {
    public void testSaveVerifierComponentAndGet() {
        VerifierData data = VerifierReportFactory.newVerifierData();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        rule.setName("0");
        String rulePath = rule.getPath();
        data.add((VerifierComponent)rule);
        Collection all = data.getAll();
        VerifierDataMapsTest.assertEquals((int)1, (int)all.size());
        VerifierDataMapsTest.assertEquals((Object)rule, (Object)all.toArray()[0]);
        Collection rules = data.getAll(VerifierComponentType.RULE);
        VerifierDataMapsTest.assertEquals((int)1, (int)rules.size());
        VerifierDataMapsTest.assertEquals((Object)rule, (Object)rules.toArray()[0]);
        VerifierRule rule2 = (VerifierRule)data.getVerifierObject(VerifierComponentType.RULE, rulePath);
        VerifierDataMapsTest.assertNotNull((Object)rule2);
        VerifierDataMapsTest.assertEquals((Object)rule, (Object)rule2);
    }

    public void testSaveVerifierComponentAndGetForAllComponentTypes() {
        RulePackage rulePackage = VerifierComponentMockFactory.createPackage1();
        this.saveVerifierComponentAndGet((VerifierComponent)rulePackage);
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        this.saveVerifierComponentAndGet((VerifierComponent)rule);
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        this.saveVerifierComponentAndGet((VerifierComponent)pattern);
        this.saveVerifierComponentAndGet((VerifierComponent)new Constraint(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new InlineEvalDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new ObjectType());
        this.saveVerifierComponentAndGet((VerifierComponent)new RuleOperatorDescr(rule, OperatorDescrType.AND));
        this.saveVerifierComponentAndGet((VerifierComponent)new PatternOperatorDescr(pattern, OperatorDescrType.AND));
        this.saveVerifierComponentAndGet((VerifierComponent)new SubPattern(pattern, 0));
        this.saveVerifierComponentAndGet((VerifierComponent)new ReturnValueFieldDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new SubRule(rule, 0));
        this.saveVerifierComponentAndGet((VerifierComponent)new TextConsequence(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new Variable(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierAccessorDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierAccumulateDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierCollectDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new RuleEval(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierFieldAccessDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierFromDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierMethodAccessDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new PatternEval(pattern));
    }

    public void testSaveVerifierComponentAndGetForAllFields() {
        this.saveVerifierComponentAndGet((Field)new EnumField());
        this.saveVerifierComponentAndGet(new Field());
    }

    public void testSaveVerifierComponentAndGetForAllRestrictions() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        this.saveVerifierComponentAndGet((Restriction)LiteralRestriction.createRestriction((Pattern)pattern, (String)""));
        this.saveVerifierComponentAndGet((Restriction)new EnumRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new QualifiedIdentifierRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new ReturnValueRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new ReturnValueRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new VariableRestriction(pattern));
    }

    public void testSavePatternAndGet() {
        VerifierData data = VerifierReportFactory.newVerifierData();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        VerifierDataMapsTest.assertNotNull((Object)rule.getName());
        VerifierDataMapsTest.assertEquals((String)"testRule1", (String)rule.getName());
        ObjectType objectType = new ObjectType();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        VerifierDataMapsTest.assertNotNull((Object)pattern.getRulePath());
        VerifierDataMapsTest.assertEquals((String)rule.getPath(), (String)pattern.getRulePath());
        VerifierDataMapsTest.assertNotNull((Object)pattern.getName());
        VerifierDataMapsTest.assertEquals((String)rule.getName(), (String)pattern.getRuleName());
        pattern.setObjectTypePath(objectType.getPath());
        VerifierDataMapsTest.assertNotNull((Object)pattern.getObjectTypePath());
        VerifierDataMapsTest.assertEquals((String)objectType.getPath(), (String)pattern.getObjectTypePath());
        data.add((VerifierComponent)rule);
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)pattern);
        Collection all = data.getAll();
        VerifierDataMapsTest.assertEquals((int)3, (int)all.size());
        VerifierDataMapsTest.assertTrue((boolean)all.contains(pattern));
        VerifierDataMapsTest.assertTrue((boolean)all.contains(objectType));
        VerifierDataMapsTest.assertTrue((boolean)all.contains(rule));
        Collection components = data.getAll(pattern.getVerifierComponentType());
        VerifierDataMapsTest.assertEquals((int)1, (int)components.size());
        VerifierDataMapsTest.assertEquals((Object)pattern, (Object)components.toArray()[0]);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        VerifierDataMapsTest.assertNotNull((Object)objectType2);
        VerifierDataMapsTest.assertEquals((Object)objectType, (Object)objectType2);
        VerifierComponent rule2 = data.getVerifierObject(rule.getVerifierComponentType(), rule.getPath());
        VerifierDataMapsTest.assertNotNull((Object)rule2);
        VerifierDataMapsTest.assertEquals((Object)rule, (Object)rule2);
    }

    private void saveVerifierComponentAndGet(Field field) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        ObjectType objectType = new ObjectType();
        field.setObjectTypePath(objectType.getPath());
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)field);
        Collection all = data.getAll();
        VerifierDataMapsTest.assertEquals((int)2, (int)all.size());
        VerifierDataMapsTest.assertTrue((boolean)all.contains(objectType));
        VerifierDataMapsTest.assertTrue((boolean)all.contains(field));
        Collection fields = data.getAll(field.getVerifierComponentType());
        VerifierDataMapsTest.assertEquals((int)1, (int)fields.size());
        VerifierDataMapsTest.assertEquals((Object)field, (Object)fields.toArray()[0]);
        VerifierComponent field2 = data.getVerifierObject(field.getVerifierComponentType(), field.getPath());
        VerifierDataMapsTest.assertNotNull((Object)field2);
        VerifierDataMapsTest.assertEquals((Object)field, (Object)field2);
        Collection objectTypes = data.getAll(objectType.getVerifierComponentType());
        VerifierDataMapsTest.assertEquals((int)1, (int)objectTypes.size());
        VerifierDataMapsTest.assertEquals((Object)objectType, (Object)objectTypes.toArray()[0]);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        VerifierDataMapsTest.assertNotNull((Object)objectType2);
        VerifierDataMapsTest.assertEquals((Object)objectType, (Object)objectType2);
    }

    private void saveVerifierComponentAndGet(Restriction component) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        ObjectType objectType = new ObjectType();
        Field field = new Field();
        field.setObjectTypePath(objectType.getPath());
        component.setFieldPath(field.getPath());
        VerifierDataMapsTest.assertNotNull((Object)component.getFieldPath());
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)field);
        data.add((VerifierComponent)component);
        Collection all = data.getAll();
        VerifierDataMapsTest.assertEquals((int)3, (int)all.size());
        VerifierDataMapsTest.assertTrue((boolean)all.contains(objectType));
        VerifierDataMapsTest.assertTrue((boolean)all.contains(field));
        VerifierDataMapsTest.assertTrue((boolean)all.contains(component));
        Collection components = data.getAll(component.getVerifierComponentType());
        VerifierDataMapsTest.assertEquals((int)1, (int)components.size());
        VerifierDataMapsTest.assertEquals((Object)component, (Object)components.toArray()[0]);
        VerifierComponent component2 = data.getVerifierObject(component.getVerifierComponentType(), component.getPath());
        VerifierDataMapsTest.assertNotNull((Object)component2);
        VerifierDataMapsTest.assertEquals((Object)component, (Object)component2);
        Collection fields = data.getAll(field.getVerifierComponentType());
        VerifierDataMapsTest.assertEquals((int)1, (int)fields.size());
        VerifierDataMapsTest.assertEquals((Object)field, (Object)fields.toArray()[0]);
        VerifierComponent field2 = data.getVerifierObject(field.getVerifierComponentType(), field.getPath());
        VerifierDataMapsTest.assertNotNull((Object)field2);
        VerifierDataMapsTest.assertEquals((Object)field, (Object)field2);
        Collection objectTypes = data.getAll(objectType.getVerifierComponentType());
        VerifierDataMapsTest.assertEquals((int)1, (int)objectTypes.size());
        VerifierDataMapsTest.assertEquals((Object)objectType, (Object)objectTypes.toArray()[0]);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        VerifierDataMapsTest.assertNotNull((Object)objectType2);
        VerifierDataMapsTest.assertEquals((Object)objectType, (Object)objectType2);
    }

    private void saveVerifierComponentAndGet(VerifierComponent component) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        data.add(component);
        Collection all = data.getAll();
        VerifierDataMapsTest.assertEquals((int)1, (int)all.size());
        VerifierDataMapsTest.assertEquals((Object)component, (Object)all.toArray()[0]);
        Collection components = data.getAll(component.getVerifierComponentType());
        VerifierDataMapsTest.assertEquals((int)1, (int)components.size());
        VerifierDataMapsTest.assertEquals((Object)component, (Object)components.toArray()[0]);
        VerifierComponent component2 = data.getVerifierObject(component.getVerifierComponentType(), component.getPath());
        VerifierDataMapsTest.assertNotNull((Object)component2);
        VerifierDataMapsTest.assertEquals((Object)component, (Object)component2);
    }
}

