/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incoherence;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.DefaultVerifierConfiguration;
import org.drools.verifier.TestBase;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;

public class IncoherentRestrictionsTest
extends TestBase {
    public void testApprovedTrueAndNotTrue() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        IncoherentRestrictionsTest.assertFalse((boolean)vBuilder.hasErrors());
        IncoherentRestrictionsTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        String str = "";
        str = String.valueOf(str) + "package mortgages\n";
        str = String.valueOf(str) + "rule \"Bankruptcy history\"\n";
        str = String.valueOf(str) + "salience 10\n";
        str = String.valueOf(str) + "dialect \"mvel\"\n";
        str = String.valueOf(str) + "when\n";
        str = String.valueOf(str) + "Applicant( approved == \"true\" , approved != \"true\" )\n";
        str = String.valueOf(str) + "then\n";
        str = String.valueOf(str) + "end";
        DefaultVerifierConfiguration conf = new DefaultVerifierConfiguration();
        conf.getVerifyingScopes().clear();
        conf.getVerifyingScopes().add("knowledge-package");
        conf.setAcceptRulesWithoutVerifiyingScope(true);
        Verifier verifier = VerifierBuilderFactory.newVerifierBuilder().newVerifier((VerifierConfiguration)conf);
        verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(str)), ResourceType.DRL);
        IncoherentRestrictionsTest.assertFalse((boolean)verifier.hasErrors());
        IncoherentRestrictionsTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        IncoherentRestrictionsTest.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        IncoherentRestrictionsTest.assertNotNull((Object)result);
        IncoherentRestrictionsTest.assertEquals((int)3, (int)result.getBySeverity(Severity.ERROR).size());
        IncoherentRestrictionsTest.assertEquals((int)1, (int)result.getBySeverity(Severity.WARNING).size());
        IncoherentRestrictionsTest.assertEquals((int)0, (int)result.getBySeverity(Severity.NOTE).size());
    }

    public void testIncoherentLiteralRestrictionsInSubPattern() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions in pattern possibility"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 1"));
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 2"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentRestrictionsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentLiteralRestrictionsInSubPatternImpossibleRanges() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible ranges"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 8"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentRestrictionsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentLiteralRestrictionsInSubPatternImpossibleEqualityLess() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible equality less or equal"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 9"));
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 11"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentRestrictionsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentLiteralRestrictionsInSubPatternImpossibleEqualityGreater() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible equality greater"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 10"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentRestrictionsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentLiteralRestrictionsInSubPatternImpossibleRange() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible range"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 7"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentRestrictionsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentVariableRestrictionsInSubPattern() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent VariableRestrictions in pattern possibility"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 3"));
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 4"));
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 5"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentRestrictionsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    public void testIncoherentVariableRestrictionsInSubPatternImpossibleRange() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent VariableRestrictions in pattern possibility, impossible range"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(((Object)((Object)this)).getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        session.executeWithResults(testData);
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            rulesThatHadErrors.add(pattern.getRuleName());
        }
        IncoherentRestrictionsTest.assertTrue((boolean)rulesThatHadErrors.remove("Incoherent restrictions 6"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                IncoherentRestrictionsTest.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

