/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.List;
import junit.framework.TestCase;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;

public class DrlPackageDataTest
extends TestCase {
    public void testHandleDrl() throws ParseException {
        String drl = "";
        drl = String.valueOf(drl) + "package org.drools.test\n";
        drl = String.valueOf(drl) + "global java.util.List list\n";
        drl = String.valueOf(drl) + "rule rule1\n";
        drl = String.valueOf(drl) + "when\n";
        drl = String.valueOf(drl) + "then\n";
        drl = String.valueOf(drl) + "list.add( drools.getRule().getName() );\n";
        drl = String.valueOf(drl) + "end\n";
        drl = String.valueOf(drl) + "rule rule2\n";
        drl = String.valueOf(drl) + "when\n";
        drl = String.valueOf(drl) + "then\n";
        drl = String.valueOf(drl) + "list.add( drools.getRule().getName() );\n";
        drl = String.valueOf(drl) + "end\n";
        DrlPackageParser s = DrlPackageParser.findPackageDataFromDrl((String)drl);
        DrlPackageDataTest.assertEquals((String)"org.drools.test", (String)s.getName());
        DrlPackageDataTest.assertEquals((int)2, (int)s.getRules().size());
        DrlPackageDataTest.assertEquals((String)"", (String)s.getDescription());
    }

    public void testHandleDrl2() throws IOException, ParseException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("DrlPackageTestData.drl")));
        String rule = "";
        while ((str = in.readLine()) != null) {
            rule = String.valueOf(rule) + str;
            rule = String.valueOf(rule) + "\n";
        }
        in.close();
        DrlPackageParser s = DrlPackageParser.findPackageDataFromDrl((String)rule);
        DrlPackageDataTest.assertNotNull((Object)s);
        DrlPackageDataTest.assertEquals((String)"org.drools.test", (String)s.getName());
        DrlPackageDataTest.assertEquals((int)5, (int)s.getRules().size());
        DrlPackageDataTest.assertEquals((String)"", (String)s.getDescription());
    }

    public void testHandleDrlNoPackageData() {
        String drl = "";
        drl = String.valueOf(drl) + "rule rule1\n";
        drl = String.valueOf(drl) + "    when\n";
        drl = String.valueOf(drl) + "    then\n";
        drl = String.valueOf(drl) + "        list.add( drools.getRule().getName() );\n";
        drl = String.valueOf(drl) + "end\n";
        boolean exception = false;
        try {
            DrlPackageParser s = DrlPackageParser.findPackageDataFromDrl((String)drl);
        }
        catch (ParseException e) {
            exception = true;
        }
        if (!exception) {
            DrlPackageDataTest.fail((String)"Should have thrown a ParseException.");
        }
    }

    public void testHandleDrlWithComments() throws ParseException {
        String drl = "";
        drl = String.valueOf(drl) + "# important information\n";
        drl = String.valueOf(drl) + "# about this package\n";
        drl = String.valueOf(drl) + "# it contains some rules\n";
        drl = String.valueOf(drl) + "package org.drools.test\n";
        drl = String.valueOf(drl) + "global java.util.List list\n";
        drl = String.valueOf(drl) + "rule rule1\n";
        drl = String.valueOf(drl) + "\twhen\n";
        drl = String.valueOf(drl) + "\tthen\n";
        drl = String.valueOf(drl) + "\t\tlist.add( drools.getRule().getName() );\n";
        drl = String.valueOf(drl) + "end\n";
        drl = String.valueOf(drl) + "rule rule2\n";
        drl = String.valueOf(drl) + "\twhen\n";
        drl = String.valueOf(drl) + "\tthen\n";
        drl = String.valueOf(drl) + "\t\tlist.add( drools.getRule().getName() );\n";
        drl = String.valueOf(drl) + "end\n";
        DrlPackageParser data = DrlPackageParser.findPackageDataFromDrl((String)drl);
        DrlPackageDataTest.assertEquals((String)"org.drools.test", (String)data.getName());
        DrlPackageDataTest.assertEquals((int)2, (int)data.getRules().size());
        DrlPackageDataTest.assertEquals((int)1, (int)data.getGlobals().size());
        DrlPackageDataTest.assertEquals((String)"java.util.List list", (String)((String)data.getGlobals().get(0)));
        DrlPackageDataTest.assertEquals((String)"important information\nabout this package\nit contains some rules\n", (String)data.getDescription());
        DrlRuleParser rd1 = (DrlRuleParser)data.getRules().get(0);
        DrlPackageDataTest.assertEquals((String)"rule1", (String)rd1.getName());
        DrlPackageDataTest.assertEquals((String)"", (String)rd1.getDescription());
        DrlRuleParser rd2 = (DrlRuleParser)data.getRules().get(1);
        DrlPackageDataTest.assertEquals((String)"rule2", (String)rd2.getName());
        DrlPackageDataTest.assertEquals((String)"", (String)rd2.getDescription());
    }

    public void testfindGlobals() {
        String header = "global LoanApplication gg";
        List globals = DrlPackageParser.findGlobals((String)header);
        DrlPackageDataTest.assertEquals((int)1, (int)globals.size());
        DrlPackageDataTest.assertEquals((String)"LoanApplication gg", (String)((String)globals.get(0)));
    }
}

