/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.util.List;
import junit.framework.TestCase;
import org.drools.verifier.misc.DrlRuleParser;

public class DrlRuleDataTest
extends TestCase {
    public void testHandleDrl() {
        String drl = "rule \"Something\" \n ";
        drl = String.valueOf(drl) + "dialect \"Java\" \n ";
        drl = String.valueOf(drl) + "\twhen \n ";
        drl = String.valueOf(drl) + "\t\tPerson() \n ";
        drl = String.valueOf(drl) + "\t\tCheesery() \n ";
        drl = String.valueOf(drl) + "\tthen \n ";
        drl = String.valueOf(drl) + "\t\tinsert( new Person()) \n ";
        drl = String.valueOf(drl) + "\t\tinsert( new Car()) \n ";
        drl = String.valueOf(drl) + "\t\tinsert( new Cheese()) \n ";
        drl = String.valueOf(drl) + "end ";
        DrlRuleParser s = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
        DrlRuleDataTest.assertEquals((int)1, (int)s.getHeader().size());
        DrlRuleDataTest.assertEquals((int)2, (int)s.getLhs().size());
        DrlRuleDataTest.assertEquals((int)3, (int)s.getRhs().size());
        DrlRuleDataTest.assertEquals((String)"", (String)s.getDescription());
    }

    public void testHandleDrlNoLineBreaks() {
        String drl = "rule \"CreditScoreApproval\" \n";
        drl = String.valueOf(drl) + "\tdialect \"mvel\" \n";
        drl = String.valueOf(drl) + "\twhen    then";
        drl = String.valueOf(drl) + "\t\tapplicant.setApproved(true) \n";
        drl = String.valueOf(drl) + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = String.valueOf(drl) + "\t\tapplicant.setAge( 10 ) \n";
        drl = String.valueOf(drl) + "end";
        DrlRuleParser s = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
        DrlRuleDataTest.assertNotNull((Object)s);
        DrlRuleDataTest.assertEquals((int)1, (int)s.getHeader().size());
        DrlRuleDataTest.assertEquals((int)0, (int)s.getLhs().size());
        DrlRuleDataTest.assertEquals((int)3, (int)s.getRhs().size());
        DrlRuleDataTest.assertEquals((String)"", (String)s.getDescription());
    }

    public void testHandleDrlWithComment() {
        String drl = "# Really important information about this rule \n";
        drl = String.valueOf(drl) + "# Another line because one was not enough \n";
        drl = String.valueOf(drl) + "#  \n";
        drl = String.valueOf(drl) + "# @author: trikkola \n";
        drl = String.valueOf(drl) + "rule \"First\" \n";
        drl = String.valueOf(drl) + "\tdialect \"mvel\" \n";
        drl = String.valueOf(drl) + "\twhen \n ";
        drl = String.valueOf(drl) + "\t\tPerson() \n ";
        drl = String.valueOf(drl) + "\t\tCheesery() \n ";
        drl = String.valueOf(drl) + "\tthen \n ";
        drl = String.valueOf(drl) + "\t\tapplicant.setApproved(true) \n";
        drl = String.valueOf(drl) + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = String.valueOf(drl) + "\t\tapplicant.setAge( 10 ) \n";
        drl = String.valueOf(drl) + "end \n";
        drl = String.valueOf(drl) + "\n";
        drl = String.valueOf(drl) + "# Really important information about this rule \n";
        drl = String.valueOf(drl) + "# Another line because one was not enough \n";
        drl = String.valueOf(drl) + "#  \n";
        drl = String.valueOf(drl) + "# @author: trikkola \n";
        drl = String.valueOf(drl) + "# @created: 29.12.2001 \n";
        drl = String.valueOf(drl) + "# @edited: 5.5.2005 \n";
        drl = String.valueOf(drl) + "rule \"Second\" \n";
        drl = String.valueOf(drl) + "\tdialect \"mvel\" \n";
        drl = String.valueOf(drl) + "\twhen \n ";
        drl = String.valueOf(drl) + "\t\tPerson() \n ";
        drl = String.valueOf(drl) + "\t\tCheesery() \n ";
        drl = String.valueOf(drl) + "\tthen \n ";
        drl = String.valueOf(drl) + "\t\tapplicant.setApproved(true) \n";
        drl = String.valueOf(drl) + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = String.valueOf(drl) + "\t\tapplicant.setAge( 10 ) \n";
        drl = String.valueOf(drl) + "end";
        drl = String.valueOf(drl) + "\n";
        drl = String.valueOf(drl) + "rule \"Third\" \n";
        drl = String.valueOf(drl) + "\tdialect \"mvel\" \n";
        drl = String.valueOf(drl) + "\twhen \n ";
        drl = String.valueOf(drl) + "\t\tPerson() \n ";
        drl = String.valueOf(drl) + "\t\tCheesery() \n ";
        drl = String.valueOf(drl) + "\tthen \n ";
        drl = String.valueOf(drl) + "\t\tapplicant.setApproved(true) \n";
        drl = String.valueOf(drl) + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = String.valueOf(drl) + "\t\tapplicant.setAge( 10 ) \n";
        drl = String.valueOf(drl) + "end";
        List list = DrlRuleParser.findRulesDataFromDrl((String)drl);
        DrlRuleDataTest.assertEquals((int)3, (int)list.size());
        DrlRuleParser rd = (DrlRuleParser)list.get(0);
        DrlRuleDataTest.assertNotNull((Object)rd);
        DrlRuleDataTest.assertEquals((int)1, (int)rd.getHeader().size());
        DrlRuleDataTest.assertEquals((int)2, (int)rd.getLhs().size());
        DrlRuleDataTest.assertEquals((int)3, (int)rd.getRhs().size());
        DrlRuleDataTest.assertEquals((int)1, (int)rd.getMetadata().size());
        DrlRuleDataTest.assertNotNull((Object)rd.getDescription());
        DrlRuleDataTest.assertNotSame((Object)"", (Object)rd.getDescription());
        DrlRuleParser rd2 = (DrlRuleParser)list.get(1);
        DrlRuleDataTest.assertNotNull((Object)rd2);
        DrlRuleDataTest.assertEquals((int)1, (int)rd2.getHeader().size());
        DrlRuleDataTest.assertEquals((int)2, (int)rd2.getLhs().size());
        DrlRuleDataTest.assertEquals((int)3, (int)rd2.getRhs().size());
        DrlRuleDataTest.assertEquals((int)3, (int)rd2.getMetadata().size());
        DrlRuleDataTest.assertNotNull((Object)rd2.getDescription());
        String description = "Really important information about this rule\n";
        description = String.valueOf(description) + "Another line because one was not enough\n\n";
        DrlRuleDataTest.assertEquals((String)description, (String)rd2.getDescription());
        DrlRuleDataTest.assertNotSame((Object)"", (Object)rd2.getDescription());
        DrlRuleParser rd3 = (DrlRuleParser)list.get(2);
        DrlRuleDataTest.assertNotNull((Object)rd3);
        DrlRuleDataTest.assertEquals((int)1, (int)rd3.getHeader().size());
        DrlRuleDataTest.assertEquals((int)2, (int)rd3.getLhs().size());
        DrlRuleDataTest.assertEquals((int)3, (int)rd3.getRhs().size());
        DrlRuleDataTest.assertNotNull((Object)rd3.getDescription());
        DrlRuleDataTest.assertEquals((String)"", (String)rd3.getDescription());
    }
}

