/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.components;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.impl.ClassPathResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.MessageType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.drools.verifier.report.components.VerifierMessageBase;

public class CauseTest
extends TestCase {
    public void testCauseTrace() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        CauseTest.assertFalse((boolean)vBuilder.hasErrors());
        CauseTest.assertEquals((int)0, (int)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Causes.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        CauseTest.assertFalse((boolean)verifier.hasErrors());
        CauseTest.assertEquals((int)0, (int)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        CauseTest.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        CauseTest.assertNotNull((Object)result);
        CauseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        Collection warnings = result.getBySeverity(Severity.WARNING);
        ArrayList<VerifierMessageBase> redundancyWarnings = new ArrayList<VerifierMessageBase>();
        for (VerifierMessageBase verifierMessageBase : warnings) {
            if (!verifierMessageBase.getMessageType().equals(MessageType.REDUNDANCY)) continue;
            redundancyWarnings.add(verifierMessageBase);
        }
        CauseTest.assertEquals((int)1, (int)redundancyWarnings.size());
        VerifierMessage message = (VerifierMessage)redundancyWarnings.toArray()[0];
        CauseTest.assertEquals((int)2, (int)message.getImpactedRules().size());
        CauseTest.assertTrue((boolean)message.getImpactedRules().values().contains("Your First Rule"));
        CauseTest.assertTrue((boolean)message.getImpactedRules().values().contains("Your Second Rule"));
        Cause[] causes = message.getCauses().toArray(new Cause[message.getCauses().size()]);
        CauseTest.assertEquals((int)1, (int)causes.length);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        CauseTest.assertEquals((int)2, (int)causes.length);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        CauseTest.assertEquals((int)1, (int)causes.length);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        CauseTest.assertEquals((int)1, (int)causes.length);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        CauseTest.assertEquals((int)2, (int)causes.length);
        CauseTest.assertEquals((int)0, (int)result.getBySeverity(Severity.NOTE).size());
    }
}

