/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.descr.PackageDescr;
import org.drools.verifier.Verifier;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.drools.verifier.visitor.UnknownDescriptionException;

public class PackageDescrVisitorTest
extends TestCase {
    public void testVisit() throws DroolsParserException, UnknownDescriptionException {
        VerifierData data = VerifierReportFactory.newVerifierData();
        PackageDescrVisitor visitor = new PackageDescrVisitor(data, Collections.EMPTY_LIST);
        PackageDescrVisitorTest.assertNotNull((Object)data);
        InputStreamReader drlReader = new InputStreamReader(Verifier.class.getResourceAsStream("Misc3.drl"));
        PackageDescr packageDescr = new DrlParser().parse((Reader)drlReader);
        PackageDescrVisitorTest.assertNotNull((Object)packageDescr);
        visitor.visitPackageDescr(packageDescr);
        Collection all = data.getAll();
        HashSet<String> names = new HashSet<String>();
        for (VerifierComponent verifierComponent : all) {
            String path = verifierComponent.getPath();
            if (names.contains(path)) {
                PackageDescrVisitorTest.fail((String)("Dublicate path " + path));
                continue;
            }
            names.add(path);
        }
        PackageDescrVisitorTest.assertNotNull((Object)all);
        PackageDescrVisitorTest.assertEquals((int)52, (int)all.size());
    }

    public void testSubPatterns() throws DroolsParserException, UnknownDescriptionException {
        VerifierData data = VerifierReportFactory.newVerifierData();
        PackageDescrVisitor visitor = new PackageDescrVisitor(data, Collections.EMPTY_LIST);
        PackageDescrVisitorTest.assertNotNull((Object)data);
        InputStreamReader drlReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("SubPattern.drl"));
        PackageDescr packageDescr = new DrlParser().parse((Reader)drlReader);
        PackageDescrVisitorTest.assertNotNull((Object)packageDescr);
        visitor.visitPackageDescr(packageDescr);
        Collection all = data.getAll();
        PackageDescrVisitorTest.assertNotNull((Object)all);
        SubPattern test1SubPattern = null;
        SubPattern test2SubPattern = null;
        SubRule test1SubRule = null;
        SubRule test2SubRule = null;
        for (VerifierComponent verifierComponent : all) {
            if (verifierComponent.getVerifierComponentType().equals(VerifierComponentType.SUB_PATTERN)) {
                SubPattern subPattern = (SubPattern)verifierComponent;
                if ("Test 1".equals(subPattern.getRuleName())) {
                    PackageDescrVisitorTest.assertNull(test1SubPattern);
                    test1SubPattern = subPattern;
                } else if ("Test 2".equals(subPattern.getRuleName())) {
                    PackageDescrVisitorTest.assertNull(test2SubPattern);
                    test2SubPattern = subPattern;
                }
            }
            if (!verifierComponent.getVerifierComponentType().equals(VerifierComponentType.SUB_RULE)) continue;
            SubRule subRule = (SubRule)verifierComponent;
            if ("Test 1".equals(subRule.getRuleName())) {
                PackageDescrVisitorTest.assertNull(test1SubRule);
                test1SubRule = subRule;
                continue;
            }
            if (!"Test 2".equals(subRule.getRuleName())) continue;
            PackageDescrVisitorTest.assertNull(test2SubRule);
            test2SubRule = subRule;
        }
        PackageDescrVisitorTest.assertNotNull(test1SubPattern);
        PackageDescrVisitorTest.assertEquals((int)3, (int)test1SubPattern.getItems().size());
        PackageDescrVisitorTest.assertNotNull(test2SubPattern);
        PackageDescrVisitorTest.assertEquals((int)3, (int)test2SubPattern.getItems().size());
        PackageDescrVisitorTest.assertNotNull(test1SubRule);
        PackageDescrVisitorTest.assertEquals((int)1, (int)test1SubRule.getItems().size());
        PackageDescrVisitorTest.assertNotNull(test2SubRule);
        PackageDescrVisitorTest.assertEquals((int)1, (int)test2SubRule.getItems().size());
    }
}

