/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.data;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Gap;
import org.drools.verifier.report.components.MissingNumberPattern;
import org.drools.verifier.report.components.MissingRange;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VerifierReportImpl
implements VerifierReport {
    private static final long serialVersionUID = -6207688526236713721L;
    private Map<String, Gap> gapsById = new TreeMap<String, Gap>();
    private Multimap<String, Gap> gapsByFieldId = new TreeMultimap();
    private Map<String, MissingNumberPattern> missingNumberPatternsById = new TreeMap<String, MissingNumberPattern>();
    private Multimap<String, MissingNumberPattern> missingNumberPatternsByFieldId = new TreeMultimap();
    private List<VerifierMessageBase> messages = new ArrayList<VerifierMessageBase>();
    private Multimap<Severity, VerifierMessageBase> messagesBySeverity = new TreeMultimap();
    private VerifierData data;

    public VerifierReportImpl(VerifierData data) {
        this.data = data;
    }

    @Override
    public void add(VerifierMessageBase message) {
        this.messages.add(message);
        this.messagesBySeverity.put((Object)message.getSeverity(), (Object)message);
    }

    @Override
    public Collection<VerifierMessageBase> getBySeverity(Severity severity) {
        Collection result = this.messagesBySeverity.get((Object)severity);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public void add(Gap gap) {
        this.gapsById.put(gap.getGuid(), gap);
        this.gapsByFieldId.put((Object)gap.getField().getPath(), (Object)gap);
    }

    @Override
    public void remove(Gap gap) {
        this.gapsById.remove(gap.getGuid());
        this.gapsByFieldId.remove((Object)gap.getField().getPath(), (Object)gap);
    }

    @Override
    public Collection<Gap> getGapsByFieldId(String fieldId) {
        return this.gapsByFieldId.get((Object)fieldId);
    }

    @Override
    public Collection<MissingRange> getRangeCheckCauses() {
        ArrayList<MissingRange> result = new ArrayList<MissingRange>();
        result.addAll(this.gapsById.values());
        result.addAll(this.missingNumberPatternsById.values());
        return result;
    }

    @Override
    public void add(MissingNumberPattern missingNumberPattern) {
        this.missingNumberPatternsById.put(missingNumberPattern.getGuid(), missingNumberPattern);
        this.missingNumberPatternsByFieldId.put((Object)missingNumberPattern.getField().getPath(), (Object)missingNumberPattern);
    }

    @Override
    public Collection<MissingRange> getRangeCheckCausesByFieldPath(String id) {
        ArrayList<MissingRange> result = new ArrayList<MissingRange>();
        result.addAll(this.gapsByFieldId.get((Object)id));
        result.addAll(this.missingNumberPatternsByFieldId.get((Object)id));
        return result;
    }

    @Override
    public VerifierData getVerifierData() {
        return this.data;
    }

    public void setVerifierData(VerifierData data) {
        this.data = data;
    }

    @Override
    public VerifierData getVerifierData(VerifierData data) {
        return this.data;
    }
}

