/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageBuilderErrors;
import org.drools.ide.common.BusinessRuleProviderDefaultImpl;
import org.drools.io.Resource;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.dsl.DefaultExpander;

class VerifierPackageBuilder {
    private InnerBuilder innerBuilder = new InnerBuilder();
    private PackageDescr packageDescr;

    VerifierPackageBuilder() {
    }

    public void addKnowledgeResource(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        this.innerBuilder.addKnowledgeResource(resource, type, configuration);
    }

    public PackageDescr getPackageDescr() {
        return this.packageDescr;
    }

    public boolean hasErrors() {
        return this.innerBuilder.hasErrors();
    }

    public PackageBuilderErrors getErrors() {
        return this.innerBuilder.getErrors();
    }

    class InnerBuilder
    extends PackageBuilder {
        public InnerBuilder() {
            super(new PackageBuilderConfiguration());
        }

        public void addPackage(PackageDescr pDescr) {
            VerifierPackageBuilder.this.packageDescr = pDescr;
        }

        public void addPackageFromBrl(Resource resource) throws DroolsParserException {
            try {
                BusinessRuleProviderDefaultImpl provider = new BusinessRuleProviderDefaultImpl();
                Reader knowledge = provider.getKnowledgeReader(resource);
                DrlParser parser = new DrlParser();
                DefaultExpander expander = this.getDslExpander();
                if (null != expander) {
                    knowledge = new StringReader(expander.expand(knowledge));
                    if (expander.hasErrors()) {
                        this.getErrors().addAll((Collection)expander.getErrors());
                    }
                }
                PackageDescr pkg = parser.parse(knowledge);
                if (parser.hasErrors()) {
                    this.getErrors().addAll((Collection)parser.getErrors());
                } else {
                    this.addPackage(pkg);
                }
            }
            catch (Exception e) {
                throw new DroolsParserException((Throwable)e);
            }
        }
    }
}

