/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatelessSession;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.compiler.DrlParser;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestBaseOld {
    @Before
    public void setUp() throws Exception {
        System.setProperty("drools.dateformat", "dd-MMM-yyyy");
    }

    public StatelessSession getStatelessSession(InputStream stream) throws Exception {
        InputStreamReader source = new InputStreamReader(stream);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)source);
        Package pkg = builder.getPackage();
        if (builder.hasErrors()) {
            for (KnowledgeBuilderError error : builder.getErrors()) {
                System.out.println(error.getMessage());
            }
            Assert.fail((String)"Builder has errors");
        }
        Assert.assertTrue((String)"Package was null.", (pkg != null ? 1 : 0) != 0);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase.newStatelessSession();
    }

    protected static boolean mapContains(Map<String, Set<String>> map, String ruleName1, String ruleName2) {
        if (map.containsKey(ruleName1)) {
            Set<String> set = map.get(ruleName1);
            boolean exists = set.remove(ruleName2);
            if (set.isEmpty()) {
                map.remove(ruleName1);
            }
            return exists;
        }
        return false;
    }

    protected static boolean causeMapContains(Map<Cause, Set<Cause>> map, Cause cause1, Cause cause2) {
        if (map.containsKey(cause1)) {
            Set<Cause> set = map.get(cause1);
            boolean exists = set.remove(cause2);
            if (set.isEmpty()) {
                map.remove(cause1);
            }
            return exists;
        }
        return false;
    }

    public Collection<? extends Object> getTestData(InputStream stream, VerifierData data) throws Exception {
        InputStreamReader drlReader = new InputStreamReader(stream);
        PackageDescr descr = new DrlParser().parse((Reader)drlReader);
        PackageDescrVisitor packageDescrVisitor = new PackageDescrVisitor(data, Collections.EMPTY_LIST);
        packageDescrVisitor.visitPackageDescr(descr);
        return data.getAll();
    }
}

