/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.jarloader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarInputStream;
import org.drools.verifier.Verifier;
import org.drools.verifier.jarloader.PackageHeaderLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageHeaderLoaderTest {
    private ArrayList<JarInputStream> jarInputStreams;

    @Before
    public void setUp() throws Exception {
        this.jarInputStreams = new ArrayList();
        this.jarInputStreams.add(new JarInputStream(Verifier.class.getResourceAsStream("model.jar")));
    }

    @After
    public void tearDown() throws Exception {
        for (JarInputStream jarInputStream : this.jarInputStreams) {
            jarInputStream.close();
        }
    }

    @Test
    public void testListAddressAndPetImport() throws Exception {
        PackageHeaderLoader packageHeaderLoader = this.getPackageHeaderLoader("org.test.Rambo", "org.test.Pet");
        Collection classNames = packageHeaderLoader.getClassNames();
        Assert.assertEquals((long)2L, (long)classNames.size());
        Assert.assertTrue((boolean)classNames.contains("org.test.Rambo"));
        Assert.assertTrue((boolean)classNames.contains("org.test.Pet"));
    }

    @Test
    public void testListFewClassesThatDoNotExist() throws Exception {
        PackageHeaderLoader packageHeaderLoader = this.getPackageHeaderLoader("org.test.Rambo", "i.do.not.Exist", "me.Neither");
        Collection classNames = packageHeaderLoader.getClassNames();
        Collection missingClasses = packageHeaderLoader.getMissingClasses();
        Assert.assertEquals((long)3L, (long)classNames.size());
        Assert.assertEquals((long)2L, (long)missingClasses.size());
    }

    @Test
    public void testListFields() throws Exception {
        PackageHeaderLoader packageHeaderLoader = this.getPackageHeaderLoader("org.test.Person");
        Collection fieldNames = packageHeaderLoader.getFieldNames("org.test.Person");
        Assert.assertTrue((boolean)fieldNames.contains("birhtday"));
        Assert.assertTrue((boolean)fieldNames.contains("firstName"));
        Assert.assertTrue((boolean)fieldNames.contains("lastName"));
        Assert.assertTrue((boolean)fieldNames.contains("pets"));
        Assert.assertTrue((boolean)fieldNames.contains("this"));
        Assert.assertEquals((Object)"java.lang.String", (Object)packageHeaderLoader.getFieldType("org.test.Person", "firstName"));
        Assert.assertEquals((Object)"java.lang.String", (Object)packageHeaderLoader.getFieldType("org.test.Person", "firstName"));
        Assert.assertEquals((Object)"java.util.List", (Object)packageHeaderLoader.getFieldType("org.test.Person", "pets"));
        Assert.assertEquals((Object)"java.util.Calendar", (Object)packageHeaderLoader.getFieldType("org.test.Person", "birhtday"));
        Assert.assertEquals((Object)"org.test.Person", (Object)packageHeaderLoader.getFieldType("org.test.Person", "this"));
        Assert.assertNull((Object)packageHeaderLoader.getFieldType("org.test.Person", "toString"));
        Assert.assertNull((Object)packageHeaderLoader.getFieldType("org.test.Person", "class"));
        Assert.assertNull((Object)packageHeaderLoader.getFieldType("org.test.Person", "hashCode"));
    }

    private PackageHeaderLoader getPackageHeaderLoader(String ... imports) {
        try {
            return new PackageHeaderLoader(this.createImportsList(imports), this.jarInputStreams);
        }
        catch (IOException e) {
            Assert.fail((String)"Failed to read the jar input streams.");
            return null;
        }
    }

    private Collection<String> createImportsList(String ... list) {
        ArrayList<String> imports = new ArrayList<String>();
        for (String s : list) {
            imports.add(s);
        }
        return imports;
    }
}

