/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.alwaysTrue;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.AlwaysTrue;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;

public class AlwaysTrueRuleTest
extends TestBaseOld {
    @Test
    public void testPatternPossibilities() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Rules.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Rule possibility that is always true"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = VerifierComponentMockFactory.createRule1();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        SubRule rp1 = new SubRule(rule1, 0);
        SubPattern pp1 = new SubPattern(pattern1, 0);
        AlwaysTrue alwaysTrue1 = new AlwaysTrue((Cause)pp1, new Cause[0]);
        SubPattern pp2 = new SubPattern(pattern1, 1);
        AlwaysTrue alwaysTrue2 = new AlwaysTrue((Cause)pp2, new Cause[0]);
        rp1.add((RuleComponent)pp1);
        rp1.add((RuleComponent)pp2);
        VerifierRule rule2 = VerifierComponentMockFactory.createRule2();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        SubRule rp2 = new SubRule(rule2, 0);
        SubPattern pp3 = new SubPattern(pattern2, 0);
        SubPattern pp4 = new SubPattern(pattern2, 1);
        AlwaysTrue alwaysTrue4 = new AlwaysTrue((Cause)pp4, new Cause[0]);
        rp2.add((RuleComponent)pp3);
        rp2.add((RuleComponent)pp4);
        data.add(rule1);
        data.add(rp1);
        data.add(pp1);
        data.add(pp2);
        data.add(alwaysTrue1);
        data.add(alwaysTrue2);
        data.add(rule2);
        data.add(rp2);
        data.add(pp3);
        data.add(pp4);
        data.add(alwaysTrue4);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Iterator iter = sessionResult.iterateObjects();
        boolean rp1true = false;
        boolean rp2true = false;
        boolean rp3true = false;
        boolean rp4true = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof AlwaysTrue)) continue;
            AlwaysTrue alwaysTrue = (AlwaysTrue)o;
            if (!rp1true) {
                rp1true = alwaysTrue.getCause().equals(pp1);
            }
            if (!rp2true) {
                rp2true = alwaysTrue.getCause().equals(pp2);
            }
            if (!rp3true) {
                rp3true = alwaysTrue.getCause().equals(pp3);
            }
            if (rp4true) continue;
            rp4true = alwaysTrue.getCause().equals(pp4);
        }
        Assert.assertTrue((boolean)rp1true);
        Assert.assertTrue((boolean)rp2true);
        Assert.assertFalse((boolean)rp3true);
        Assert.assertTrue((boolean)rp4true);
    }

    @Test
    public void testPatterns() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Rules.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Rule that is always true"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        ArrayList<Object> data = new ArrayList<Object>();
        session.setGlobal("result", (Object)result);
        VerifierRule rule1 = VerifierComponentMockFactory.createRule1();
        SubRule rp1 = new SubRule(rule1, 0);
        AlwaysTrue alwaysTrue1 = new AlwaysTrue((Cause)rp1, new Cause[0]);
        SubRule rp2 = new SubRule(rule1, 1);
        AlwaysTrue alwaysTrue2 = new AlwaysTrue((Cause)rp2, new Cause[0]);
        VerifierRule rule2 = VerifierComponentMockFactory.createRule2();
        SubRule rp3 = new SubRule(rule2, 0);
        SubRule rp4 = new SubRule(rule2, 1);
        AlwaysTrue alwaysTrue4 = new AlwaysTrue((Cause)rp4, new Cause[0]);
        data.add(rule1);
        data.add(rp1);
        data.add(rp2);
        data.add(alwaysTrue1);
        data.add(alwaysTrue2);
        data.add(rule2);
        data.add(rp3);
        data.add(rp4);
        data.add(alwaysTrue4);
        session.executeWithResults(data);
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        boolean works = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            if (message.getFaulty().equals(rule1)) {
                works = true;
                continue;
            }
            Assert.fail((String)"There can be only one. (And this is not the one)");
        }
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.ERROR).size());
        Assert.assertEquals((long)1L, (long)result.getBySeverity(Severity.WARNING).size());
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.NOTE).size());
        Assert.assertTrue((boolean)works);
    }
}

