/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.util.Collection;
import org.drools.base.evaluators.Operator;
import org.drools.lang.descr.PackageDescr;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.Eval;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.NumberRestriction;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.StringRestriction;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;
import org.junit.Assert;
import org.junit.Test;

public class ExprConstraintDescrVisitorTest
extends TestBase {
    @Test
    public void testVisitPerson() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(this.getClass().getResourceAsStream("ExprConstraintDescr1.drl"));
        Assert.assertNotNull((Object)packageDescr);
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        Collection allFields = this.verifierData.getAll(VerifierComponentType.FIELD);
        Assert.assertEquals((long)3L, (long)allRestrictions.size());
        Assert.assertEquals((long)3L, (long)allFields.size());
        for (Field field : allFields) {
            Assert.assertNotNull((Object)field.getFieldType());
        }
        this.assertContainsField("name");
        this.assertContainsField("lastName");
        this.assertContainsField("age");
        this.assertContainsStringRestriction(Operator.EQUAL, "toni");
        this.assertContainsStringRestriction(Operator.NOT_EQUAL, "Lake");
        this.assertContainsNumberRestriction(Operator.GREATER, 20);
        this.assertContainsEval("eval( true )");
    }

    @Test
    public void testVisitAnd() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(this.getClass().getResourceAsStream("ExprConstraintDescr2.drl"));
        Assert.assertNotNull((Object)packageDescr);
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        Assert.assertEquals((long)2L, (long)allRestrictions.size());
        this.assertContainsFields(1);
        this.assertContainsField("age");
        this.assertContainsNumberRestriction(Operator.GREATER, 0);
        this.assertContainsNumberRestriction(Operator.LESS, 100);
    }

    @Test
    public void testVisitVariableRestriction() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(this.getClass().getResourceAsStream("ExprConstraintDescr3.drl"));
        Assert.assertNotNull((Object)packageDescr);
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        Assert.assertEquals((long)1L, (long)allRestrictions.size());
        this.assertContainsFields(1);
        this.assertContainsField("age");
        this.assertContainsVariable("Test 1", "var");
        this.assertContainsVariableRestriction(Operator.EQUAL, "var");
    }

    private void assertContainsEval(String eval) {
        Collection allEvals = this.verifierData.getAll(VerifierComponentType.PREDICATE);
        for (VerifierComponent component : allEvals) {
            Eval evalObject = (Eval)component;
            if (!eval.equals(evalObject.getContent())) continue;
            return;
        }
        Assert.fail((String)String.format("Could not find Eval : %s ", eval));
    }

    private void assertContainsVariableRestriction(Operator operator, String variableName) {
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        for (Restriction restriction : allRestrictions) {
            VariableRestriction variableRestriction;
            if (!(restriction instanceof VariableRestriction) || !variableName.equals((variableRestriction = (VariableRestriction)restriction).getVariable().getName()) || !operator.equals((Object)variableRestriction.getOperator())) continue;
            return;
        }
        Assert.fail((String)String.format("Could not find VariableRestriction: Operator : %s Variable name: %s", operator, variableName));
    }

    private void assertContainsStringRestriction(Operator operator, String value) {
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        for (Restriction restriction : allRestrictions) {
            StringRestriction stringLiteral;
            if (!(restriction instanceof StringRestriction) || !value.equals((stringLiteral = (StringRestriction)restriction).getValueAsString()) || !operator.equals((Object)stringLiteral.getOperator())) continue;
            return;
        }
        Assert.fail((String)String.format("Could not find StringRestriction: Operator : %s Value: %s", operator, value));
    }

    private void assertContainsNumberRestriction(Operator operator, Number value) {
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        for (Restriction restriction : allRestrictions) {
            NumberRestriction numberRestriction;
            if (!(restriction instanceof NumberRestriction) || !value.equals((numberRestriction = (NumberRestriction)restriction).getValue()) || !operator.equals((Object)numberRestriction.getOperator())) continue;
            return;
        }
        Assert.fail((String)String.format("Could not find NumberRestriction: Operator : %s Value: %s", operator, value));
    }
}

