/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.solver.Solvers;
import org.junit.Assert;
import org.junit.Test;

public class SolversTest {
    @Test
    public void testNotAnd() {
        PackageDescr descr = new PackageDescr("testPackage");
        RulePackage rulePackage = new RulePackage(descr);
        rulePackage.setName("testPackage");
        VerifierRule rule = new VerifierRule((BaseDescr)descr, rulePackage, new HashMap());
        rule.setName("testRule");
        Pattern pattern = new Pattern(new PatternDescr(), rule);
        LiteralRestriction r = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        Solvers solvers = new Solvers();
        solvers.startRuleSolver(rule);
        solvers.startOperator(OperatorDescrType.AND);
        solvers.startPatternSolver(pattern);
        solvers.startOperator(OperatorDescrType.AND);
        solvers.addPatternComponent((PatternComponent)r);
        solvers.addPatternComponent((PatternComponent)r2);
        solvers.endOperator();
        solvers.endPatternSolver();
        solvers.startNot();
        solvers.startPatternSolver(pattern);
        solvers.startOperator(OperatorDescrType.AND);
        solvers.addPatternComponent((PatternComponent)r3);
        solvers.addPatternComponent((PatternComponent)r4);
        solvers.endOperator();
        solvers.endPatternSolver();
        solvers.endNot();
        solvers.endOperator();
        solvers.endRuleSolver();
        List list = solvers.getRulePossibilities();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((SubRule)list.get(0)).getItems().size());
        ArrayList<LiteralRestriction> result = new ArrayList<LiteralRestriction>();
        result.add(r);
        result.add(r2);
        ArrayList<LiteralRestriction> result2 = new ArrayList<LiteralRestriction>();
        result2.add(r3);
        result2.add(r4);
        Object[] possibilies = ((SubRule)list.get(0)).getItems().toArray();
        SubPattern p1 = (SubPattern)possibilies[0];
        SubPattern p2 = (SubPattern)possibilies[1];
        if (p1.getItems().containsAll(result)) {
            Assert.assertTrue((boolean)p2.getItems().containsAll(result2));
        } else if (p1.getItems().containsAll(result2)) {
            Assert.assertTrue((boolean)p2.getItems().containsAll(result));
        } else {
            Assert.fail((String)"No items found.");
        }
    }

    @Test
    public void testBasicAnd() {
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction r = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        Solvers solvers = new Solvers();
        solvers.startRuleSolver(rule);
        solvers.startPatternSolver(pattern);
        solvers.startOperator(OperatorDescrType.AND);
        solvers.addPatternComponent((PatternComponent)r);
        solvers.addPatternComponent((PatternComponent)r2);
        solvers.endOperator();
        solvers.endPatternSolver();
        solvers.endRuleSolver();
        List list = solvers.getRulePossibilities();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((SubRule)list.get(0)).getItems().size());
        ArrayList<LiteralRestriction> result = new ArrayList<LiteralRestriction>();
        result.add(r);
        result.add(r2);
        Set set = ((SubRule)list.get(0)).getItems();
        for (RuleComponent component : set) {
            SubPattern possibility = (SubPattern)component;
            Assert.assertTrue((boolean)possibility.getItems().containsAll(result));
        }
    }
}

