/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.Collections;
import org.drools.io.impl.ClassPathResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.junit.Assert;
import org.junit.Test;
import org.kie.builder.ResourceType;
import org.kie.io.Resource;

public class VerifyingScopeTest {
    @Test
    public void testSingleRule() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(true, "single-rule"));
        if (!works) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            Assert.fail((String)"Error when building in verifier");
        }
        VerifierReport result = verifier.getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.ERROR).size());
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.WARNING).size());
        Assert.assertEquals((long)6L, (long)result.getBySeverity(Severity.NOTE).size());
    }

    @Test
    public void testNothing() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(true, (Collection)Collections.EMPTY_LIST));
        Assert.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.ERROR).size());
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.WARNING).size());
        Assert.assertEquals((long)2L, (long)result.getBySeverity(Severity.NOTE).size());
    }

    @Test
    public void testDecisionTable() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(false, "decision-table"));
        Assert.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.ERROR).size());
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.WARNING).size());
        Assert.assertEquals((long)2L, (long)result.getBySeverity(Severity.NOTE).size());
    }
}

